/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.AbstractTiledRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public class FloodRed
extends AbstractRed {
    private WritableRaster raster;

    public FloodRed(Rectangle rectangle) {
        this(rectangle, new Color(0, 0, 0, 0));
    }

    public FloodRed(Rectangle rectangle, Paint paint) {
        int n;
        ColorModel colorModel = GraphicsUtil.sRGB_Unpre;
        int n2 = AbstractTiledRed.getDefaultTileSize();
        int n3 = rectangle.width;
        if (n3 > n2) {
            n3 = n2;
        }
        if ((n = rectangle.height) > n2) {
            n = n2;
        }
        SampleModel sampleModel = colorModel.createCompatibleSampleModel(n3, n);
        this.init((CachableRed)null, rectangle, colorModel, sampleModel, 0, 0, null);
        this.raster = Raster.createWritableRaster(sampleModel, new Point(0, 0));
        BufferedImage bufferedImage = new BufferedImage(colorModel, this.raster, colorModel.isAlphaPremultiplied(), null);
        Graphics2D graphics2D = GraphicsUtil.createGraphics(bufferedImage);
        graphics2D.setPaint(paint);
        graphics2D.fillRect(0, 0, rectangle.width, rectangle.height);
        graphics2D.dispose();
    }

    public Raster getTile(int n, int n2) {
        int n3 = this.tileGridXOff + n * this.tileWidth;
        int n4 = this.tileGridYOff + n2 * this.tileHeight;
        return this.raster.createTranslatedChild(n3, n4);
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        int n = this.getXTile(writableRaster.getMinX());
        int n2 = this.getYTile(writableRaster.getMinY());
        int n3 = this.getXTile(writableRaster.getMinX() + writableRaster.getWidth() - 1);
        int n4 = this.getYTile(writableRaster.getMinY() + writableRaster.getHeight() - 1);
        boolean bl = GraphicsUtil.is_INT_PACK_Data(this.getSampleModel(), false);
        for (int i = n2; i <= n4; ++i) {
            for (int j = n; j <= n3; ++j) {
                Raster raster = this.getTile(j, i);
                if (bl) {
                    GraphicsUtil.copyData_INT_PACK(raster, writableRaster);
                    continue;
                }
                GraphicsUtil.copyData_FALLBACK(raster, writableRaster);
            }
        }
        return writableRaster;
    }
}

