# coding: utf-8

"""
    NetHSM
    All endpoints expect exactly the specified JSON. Additional properties will cause a Bad Request Error (400). All HTTP errors contain a JSON structure with an explanation of type string. All [base64](https://tools.ietf.org/html/rfc4648#section-4) encoded values are Big Endian.   # noqa: E501
    The version of the OpenAPI document: v1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

from __future__ import annotations
from nethsm.client.shared_imports.schema_imports import *  # pyright: ignore [reportWildcardImportFromLibrary]



class KeyMechanismEnums:

    @schemas.classproperty
    def RSA_DECRYPTION_RAW(cls) -> typing.Literal["RSA_Decryption_RAW"]:
        return KeyMechanism.validate("RSA_Decryption_RAW")

    @schemas.classproperty
    def RSA_DECRYPTION_PKCS1(cls) -> typing.Literal["RSA_Decryption_PKCS1"]:
        return KeyMechanism.validate("RSA_Decryption_PKCS1")

    @schemas.classproperty
    def RSA_DECRYPTION_OAEP_MD5(cls) -> typing.Literal["RSA_Decryption_OAEP_MD5"]:
        return KeyMechanism.validate("RSA_Decryption_OAEP_MD5")

    @schemas.classproperty
    def RSA_DECRYPTION_OAEP_SHA1(cls) -> typing.Literal["RSA_Decryption_OAEP_SHA1"]:
        return KeyMechanism.validate("RSA_Decryption_OAEP_SHA1")

    @schemas.classproperty
    def RSA_DECRYPTION_OAEP_SHA224(cls) -> typing.Literal["RSA_Decryption_OAEP_SHA224"]:
        return KeyMechanism.validate("RSA_Decryption_OAEP_SHA224")

    @schemas.classproperty
    def RSA_DECRYPTION_OAEP_SHA256(cls) -> typing.Literal["RSA_Decryption_OAEP_SHA256"]:
        return KeyMechanism.validate("RSA_Decryption_OAEP_SHA256")

    @schemas.classproperty
    def RSA_DECRYPTION_OAEP_SHA384(cls) -> typing.Literal["RSA_Decryption_OAEP_SHA384"]:
        return KeyMechanism.validate("RSA_Decryption_OAEP_SHA384")

    @schemas.classproperty
    def RSA_DECRYPTION_OAEP_SHA512(cls) -> typing.Literal["RSA_Decryption_OAEP_SHA512"]:
        return KeyMechanism.validate("RSA_Decryption_OAEP_SHA512")

    @schemas.classproperty
    def RSA_SIGNATURE_PKCS1(cls) -> typing.Literal["RSA_Signature_PKCS1"]:
        return KeyMechanism.validate("RSA_Signature_PKCS1")

    @schemas.classproperty
    def RSA_SIGNATURE_PSS_MD5(cls) -> typing.Literal["RSA_Signature_PSS_MD5"]:
        return KeyMechanism.validate("RSA_Signature_PSS_MD5")

    @schemas.classproperty
    def RSA_SIGNATURE_PSS_SHA1(cls) -> typing.Literal["RSA_Signature_PSS_SHA1"]:
        return KeyMechanism.validate("RSA_Signature_PSS_SHA1")

    @schemas.classproperty
    def RSA_SIGNATURE_PSS_SHA224(cls) -> typing.Literal["RSA_Signature_PSS_SHA224"]:
        return KeyMechanism.validate("RSA_Signature_PSS_SHA224")

    @schemas.classproperty
    def RSA_SIGNATURE_PSS_SHA256(cls) -> typing.Literal["RSA_Signature_PSS_SHA256"]:
        return KeyMechanism.validate("RSA_Signature_PSS_SHA256")

    @schemas.classproperty
    def RSA_SIGNATURE_PSS_SHA384(cls) -> typing.Literal["RSA_Signature_PSS_SHA384"]:
        return KeyMechanism.validate("RSA_Signature_PSS_SHA384")

    @schemas.classproperty
    def RSA_SIGNATURE_PSS_SHA512(cls) -> typing.Literal["RSA_Signature_PSS_SHA512"]:
        return KeyMechanism.validate("RSA_Signature_PSS_SHA512")

    @schemas.classproperty
    def ED_DSA_SIGNATURE(cls) -> typing.Literal["EdDSA_Signature"]:
        return KeyMechanism.validate("EdDSA_Signature")

    @schemas.classproperty
    def ECDSA_SIGNATURE(cls) -> typing.Literal["ECDSA_Signature"]:
        return KeyMechanism.validate("ECDSA_Signature")

    @schemas.classproperty
    def AES_ENCRYPTION_CBC(cls) -> typing.Literal["AES_Encryption_CBC"]:
        return KeyMechanism.validate("AES_Encryption_CBC")

    @schemas.classproperty
    def AES_DECRYPTION_CBC(cls) -> typing.Literal["AES_Decryption_CBC"]:
        return KeyMechanism.validate("AES_Decryption_CBC")


@dataclasses.dataclass(frozen=True)
class KeyMechanism(
    schemas.Schema
):
    """NOTE: This class is auto generated by OpenAPI JSON Schema Generator.
    Ref: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator

    Do not edit the class manually.
    """
    types: typing.FrozenSet[typing.Type] = frozenset({
        str,
    })
    enum_value_to_name: typing.Mapping[typing.Union[int, float, str, schemas.Bool, None], str] = dataclasses.field(
        default_factory=lambda: {
            "RSA_Decryption_RAW": "RSA_DECRYPTION_RAW",
            "RSA_Decryption_PKCS1": "RSA_DECRYPTION_PKCS1",
            "RSA_Decryption_OAEP_MD5": "RSA_DECRYPTION_OAEP_MD5",
            "RSA_Decryption_OAEP_SHA1": "RSA_DECRYPTION_OAEP_SHA1",
            "RSA_Decryption_OAEP_SHA224": "RSA_DECRYPTION_OAEP_SHA224",
            "RSA_Decryption_OAEP_SHA256": "RSA_DECRYPTION_OAEP_SHA256",
            "RSA_Decryption_OAEP_SHA384": "RSA_DECRYPTION_OAEP_SHA384",
            "RSA_Decryption_OAEP_SHA512": "RSA_DECRYPTION_OAEP_SHA512",
            "RSA_Signature_PKCS1": "RSA_SIGNATURE_PKCS1",
            "RSA_Signature_PSS_MD5": "RSA_SIGNATURE_PSS_MD5",
            "RSA_Signature_PSS_SHA1": "RSA_SIGNATURE_PSS_SHA1",
            "RSA_Signature_PSS_SHA224": "RSA_SIGNATURE_PSS_SHA224",
            "RSA_Signature_PSS_SHA256": "RSA_SIGNATURE_PSS_SHA256",
            "RSA_Signature_PSS_SHA384": "RSA_SIGNATURE_PSS_SHA384",
            "RSA_Signature_PSS_SHA512": "RSA_SIGNATURE_PSS_SHA512",
            "EdDSA_Signature": "ED_DSA_SIGNATURE",
            "ECDSA_Signature": "ECDSA_SIGNATURE",
            "AES_Encryption_CBC": "AES_ENCRYPTION_CBC",
            "AES_Decryption_CBC": "AES_DECRYPTION_CBC",
        }
    )
    enums = KeyMechanismEnums

    @typing.overload
    @classmethod
    def validate(
        cls,
        arg: typing.Literal["RSA_Decryption_RAW"],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> typing.Literal["RSA_Decryption_RAW"]: ...
    @typing.overload
    @classmethod
    def validate(
        cls,
        arg: typing.Literal["RSA_Decryption_PKCS1"],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> typing.Literal["RSA_Decryption_PKCS1"]: ...
    @typing.overload
    @classmethod
    def validate(
        cls,
        arg: typing.Literal["RSA_Decryption_OAEP_MD5"],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> typing.Literal["RSA_Decryption_OAEP_MD5"]: ...
    @typing.overload
    @classmethod
    def validate(
        cls,
        arg: typing.Literal["RSA_Decryption_OAEP_SHA1"],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> typing.Literal["RSA_Decryption_OAEP_SHA1"]: ...
    @typing.overload
    @classmethod
    def validate(
        cls,
        arg: typing.Literal["RSA_Decryption_OAEP_SHA224"],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> typing.Literal["RSA_Decryption_OAEP_SHA224"]: ...
    @typing.overload
    @classmethod
    def validate(
        cls,
        arg: typing.Literal["RSA_Decryption_OAEP_SHA256"],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> typing.Literal["RSA_Decryption_OAEP_SHA256"]: ...
    @typing.overload
    @classmethod
    def validate(
        cls,
        arg: typing.Literal["RSA_Decryption_OAEP_SHA384"],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> typing.Literal["RSA_Decryption_OAEP_SHA384"]: ...
    @typing.overload
    @classmethod
    def validate(
        cls,
        arg: typing.Literal["RSA_Decryption_OAEP_SHA512"],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> typing.Literal["RSA_Decryption_OAEP_SHA512"]: ...
    @typing.overload
    @classmethod
    def validate(
        cls,
        arg: typing.Literal["RSA_Signature_PKCS1"],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> typing.Literal["RSA_Signature_PKCS1"]: ...
    @typing.overload
    @classmethod
    def validate(
        cls,
        arg: typing.Literal["RSA_Signature_PSS_MD5"],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> typing.Literal["RSA_Signature_PSS_MD5"]: ...
    @typing.overload
    @classmethod
    def validate(
        cls,
        arg: typing.Literal["RSA_Signature_PSS_SHA1"],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> typing.Literal["RSA_Signature_PSS_SHA1"]: ...
    @typing.overload
    @classmethod
    def validate(
        cls,
        arg: typing.Literal["RSA_Signature_PSS_SHA224"],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> typing.Literal["RSA_Signature_PSS_SHA224"]: ...
    @typing.overload
    @classmethod
    def validate(
        cls,
        arg: typing.Literal["RSA_Signature_PSS_SHA256"],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> typing.Literal["RSA_Signature_PSS_SHA256"]: ...
    @typing.overload
    @classmethod
    def validate(
        cls,
        arg: typing.Literal["RSA_Signature_PSS_SHA384"],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> typing.Literal["RSA_Signature_PSS_SHA384"]: ...
    @typing.overload
    @classmethod
    def validate(
        cls,
        arg: typing.Literal["RSA_Signature_PSS_SHA512"],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> typing.Literal["RSA_Signature_PSS_SHA512"]: ...
    @typing.overload
    @classmethod
    def validate(
        cls,
        arg: typing.Literal["EdDSA_Signature"],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> typing.Literal["EdDSA_Signature"]: ...
    @typing.overload
    @classmethod
    def validate(
        cls,
        arg: typing.Literal["ECDSA_Signature"],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> typing.Literal["ECDSA_Signature"]: ...
    @typing.overload
    @classmethod
    def validate(
        cls,
        arg: typing.Literal["AES_Encryption_CBC"],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> typing.Literal["AES_Encryption_CBC"]: ...
    @typing.overload
    @classmethod
    def validate(
        cls,
        arg: typing.Literal["AES_Decryption_CBC"],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> typing.Literal["AES_Decryption_CBC"]: ...
    @typing.overload
    @classmethod
    def validate(
        cls,
        arg: str,
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> typing.Literal["RSA_Decryption_RAW","RSA_Decryption_PKCS1","RSA_Decryption_OAEP_MD5","RSA_Decryption_OAEP_SHA1","RSA_Decryption_OAEP_SHA224","RSA_Decryption_OAEP_SHA256","RSA_Decryption_OAEP_SHA384","RSA_Decryption_OAEP_SHA512","RSA_Signature_PKCS1","RSA_Signature_PSS_MD5","RSA_Signature_PSS_SHA1","RSA_Signature_PSS_SHA224","RSA_Signature_PSS_SHA256","RSA_Signature_PSS_SHA384","RSA_Signature_PSS_SHA512","EdDSA_Signature","ECDSA_Signature","AES_Encryption_CBC","AES_Decryption_CBC",]: ...
    @classmethod
    def validate(
        cls,
        arg,
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> typing.Literal[
        "RSA_Decryption_RAW",
        "RSA_Decryption_PKCS1",
        "RSA_Decryption_OAEP_MD5",
        "RSA_Decryption_OAEP_SHA1",
        "RSA_Decryption_OAEP_SHA224",
        "RSA_Decryption_OAEP_SHA256",
        "RSA_Decryption_OAEP_SHA384",
        "RSA_Decryption_OAEP_SHA512",
        "RSA_Signature_PKCS1",
        "RSA_Signature_PSS_MD5",
        "RSA_Signature_PSS_SHA1",
        "RSA_Signature_PSS_SHA224",
        "RSA_Signature_PSS_SHA256",
        "RSA_Signature_PSS_SHA384",
        "RSA_Signature_PSS_SHA512",
        "EdDSA_Signature",
        "ECDSA_Signature",
        "AES_Encryption_CBC",
        "AES_Decryption_CBC",
    ]:
        validated_arg = super().validate_base(
            arg,
            configuration=configuration,
        )
        return typing.cast(typing.Literal[
                "RSA_Decryption_RAW",
                "RSA_Decryption_PKCS1",
                "RSA_Decryption_OAEP_MD5",
                "RSA_Decryption_OAEP_SHA1",
                "RSA_Decryption_OAEP_SHA224",
                "RSA_Decryption_OAEP_SHA256",
                "RSA_Decryption_OAEP_SHA384",
                "RSA_Decryption_OAEP_SHA512",
                "RSA_Signature_PKCS1",
                "RSA_Signature_PSS_MD5",
                "RSA_Signature_PSS_SHA1",
                "RSA_Signature_PSS_SHA224",
                "RSA_Signature_PSS_SHA256",
                "RSA_Signature_PSS_SHA384",
                "RSA_Signature_PSS_SHA512",
                "EdDSA_Signature",
                "ECDSA_Signature",
                "AES_Encryption_CBC",
                "AES_Decryption_CBC",
            ],
            validated_arg
        )
