"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLanguage = getLanguage;
exports.getLanguageService = getLanguageService;
exports.createLanguageServices = createLanguageServices;
const vscode_css_languageservice_1 = require("vscode-css-languageservice");
const svelte_selectors_1 = require("./features/svelte-selectors");
const customDataProvider = {
    providePseudoClasses() {
        return svelte_selectors_1.pseudoClass;
    },
    provideProperties() {
        return [
            {
                name: 'vector-effect',
                values: [{ name: 'non-scaling-stroke' }, { name: 'none' }],
                status: 'experimental'
            },
            {
                name: 'print-color-adjust',
                values: [{ name: 'economy' }, { name: 'exact' }],
                status: 'experimental'
            }
        ];
    },
    provideAtDirectives() {
        return [];
    },
    providePseudoElements() {
        return [];
    }
};
function getLanguage(kind) {
    switch (kind) {
        case 'scss':
        case 'text/scss':
            return 'scss';
        case 'less':
        case 'text/less':
            return 'less';
        case 'css':
        case 'text/css':
        default:
            return 'css';
    }
}
function getLanguageService(langs, kind) {
    const lang = getLanguage(kind);
    return langs[lang];
}
function createLanguageServices(options) {
    const [css, less, scss] = [
        vscode_css_languageservice_1.getCSSLanguageService,
        vscode_css_languageservice_1.getLESSLanguageService,
        vscode_css_languageservice_1.getSCSSLanguageService
    ].map((getService) => getService({
        customDataProviders: [customDataProvider],
        ...(options ?? {})
    }));
    return {
        css,
        less,
        scss
    };
}
//# sourceMappingURL=service.js.map