# Element
[![Build Status](https://travis-ci.org/kushview/element.svg?branch=master)](https://travis-ci.org/kushview/element)
![Element Screenshot](docs/img/Element-The-Message.png)

### ADVANCED AUDIO PLUGIN HOST
This is the community version of Element, a modular AU/LV2/VST/VST3 audio plugin host. Create powerful effects, racks and instruments by connecting nodes to one another.  Integrates with your existing hardware via standard protocols such as MIDI.

### Documentation
See [Element](https://element.readthedocs.io) on Read the Docs.

### Building 
See [building.md](./docs/building.md) for instructions and dependency information

### Features
* Runs standalone or as a plugin in your DAW**
* Route Audio and MIDI from anywhere to anywhere
* Play virtual instruments and effects live
* Create re-usable instruments and effect graphs
* Preloaded plugin graphs
* External Sync w/ MIDI Clock
* MIDI Controller Mapping
* Sub Graphing – Nest Graphs within each other.
* Custom Keyboard Shortcuts
* Placeholder Nodes
* Built In Virtual Keyboard
* Multiple Undo/Redo
* And more...

### Compatibility
Element currently loads most major plugin formats. Not seeing yours? [Check the issue tracker](https://github.com/kushview/element/issues)

| OS       | Version       | Formats     |
| -------- |:-------------:| -----------:|
| Linux*   |       -       | LADSPA/LV2/VST3 |
| Mac OSX  | 10.8 and up   | AU/VST/VST3 |
| Windows  | XP and up     | VST/VST3    |

_*Ubuntu is the most tested, but should run on any major distribution_

### Contributing
Want to help widdle down the TODO list? Please review the [code style](docs/code-style.md) and [contributor notes](CONTRIBUTING.md) before submitting pull requests.  You may also want to join the [#element-dev](https://discord.gg/mSDmPrj) channel on the Kushview [Discord](https://discord.gg/mSDmPrj) server.

### Issue Reporting
Please report bugs and feature requests on Github. [Element issue tracker](https://github.com/kushview/element/issues).

### Sponsors & Support
This project has been made possible by our Pro license holders & Patrons. Element never would have made it this far without you!  If you'd like to support the project, you can do so by subscribing or purchasing a pre-built binary on [kushview.net](https://kushview.net/element/)

### Donations
Support Kushview with crypto!  If you're building from source, or installing by normal means on Linux, this is the best way to donate.

| Coin     | Address                            |
| -------- |:----------------------------------:|
| Bitcoin  | 3CmHtp5eUe4VHdcrUMb82vDBqRmX3AQ7U5 |
| Litecoin | MCkYJxaeWN18AgJrZHbsKduTdjZsmjNk7V |
| Ethereum | 0xc2D1fC4197580B61ad76B66906eC5abe71C7f912 |
