/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

public enum Size {
    TINY(0.25f, 12.0f),
    SMALLER(0.5f, 14.0f),
    SMALL(0.75f, 16.0f),
    NORMAL(1.0f, 18.0f),
    LARGE(1.25f, 20.0f),
    BIG(1.5f, 24.0f),
    HUGE(1.75f, 32.0f),
    MAX(2.0f, 40.0f);

    private final float image;
    private final float font;

    private Size(float image, float font) {
        this.image = image;
        this.font = font;
    }

    public float forImage() {
        return this.image;
    }

    public float forFont() {
        return this.font;
    }

    public Size scaled(float f) {
        int val = this.ordinal() + Math.round(4.0f * (f - 1.0f));
        return val < 0 || val >= MAX.ordinal() ? null : Size.values()[val];
    }

    public Size up() {
        return this == MAX ? MAX : Size.values()[this.ordinal() + 1];
    }

    public Size down() {
        return this == TINY ? TINY : Size.values()[this.ordinal() - 1];
    }
}

