/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.dialog;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.PanelUI;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.dialog.FreeColConfirmDialog;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.plaf.FreeColSelectedPanelUI;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;

public final class EndTurnDialog
extends FreeColConfirmDialog {
    private static final Logger logger = Logger.getLogger(EndTurnDialog.class.getName());
    private final JList<UnitWrapper> unitList;

    public EndTurnDialog(FreeColClient freeColClient, JFrame frame, List<Unit> units) {
        super(freeColClient, frame);
        Player player = this.getMyPlayer();
        JLabel header = Utility.localizedHeader(Messages.nameKey("endTurnDialog"), Utility.FONTSPEC_TITLE);
        JTextArea text = Utility.localizedTextArea(StringTemplate.template("endTurnDialog.areYouSure").addAmount("%number%", units.size()));
        DefaultListModel<UnitWrapper> model = new DefaultListModel<UnitWrapper>();
        for (Unit unit : units) {
            model.addElement(new UnitWrapper(unit));
        }
        this.unitList = new JList(model);
        this.unitList.setCellRenderer(new UnitCellRenderer());
        this.unitList.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "select");
        this.unitList.getActionMap().put("select", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                EndTurnDialog.this.selectUnit();
            }
        });
        this.unitList.getInputMap().put(KeyStroke.getKeyStroke("ESCAPE"), "quit");
        this.unitList.getActionMap().put("quit", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                EndTurnDialog.this.setValue(EndTurnDialog.this.options.get(1));
            }
        });
        this.unitList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                EndTurnDialog.this.selectUnit();
            }
        });
        JScrollPane listScroller = new JScrollPane(this.unitList);
        MigPanel panel = new MigPanel(new MigLayout("wrap 1, fill", "[align center]"));
        panel.add(header);
        panel.add((Component)text, "newline 20");
        panel.add((Component)listScroller, "newline 10");
        panel.setSize(panel.getPreferredSize());
        ImageIcon icon = new ImageIcon(this.getImageLibrary().getScaledNationImage(player.getNation()));
        this.initializeConfirmDialog(frame, false, panel, icon, "ok", "cancel");
    }

    private void selectUnit() {
        UnitWrapper wrapper = this.unitList.getSelectedValue();
        if (wrapper != null && wrapper.unit != null) {
            if (wrapper.unit.isInEurope()) {
                this.getGUI().showEuropePanel();
            } else {
                this.getGUI().changeView(wrapper.unit, false);
                if (wrapper.unit.getColony() != null) {
                    this.getGUI().showColonyPanel(wrapper.unit.getColony(), wrapper.unit);
                }
            }
        }
    }

    private class UnitCellRenderer
    implements ListCellRenderer<UnitWrapper> {
        @Override
        public Component getListCellRendererComponent(JList<? extends UnitWrapper> list, UnitWrapper value, int index, boolean isSelected, boolean cellHasFocus) {
            MigPanel panel;
            JLabel imageLabel = new JLabel();
            imageLabel.setIcon(new ImageIcon(EndTurnDialog.this.getImageLibrary().getSmallerUnitImage(value.unit)));
            imageLabel.setHorizontalAlignment(0);
            JLabel nameLabel = new JLabel();
            nameLabel.setText(value.name);
            JLabel locationLabel = new JLabel();
            locationLabel.setFont(locationLabel.getFont().deriveFont(2));
            locationLabel.setText(value.location);
            if (isSelected) {
                panel = new MigPanel(new MigLayout("", "[fill]"));
                panel.setOpaque(false);
                panel.setUI((PanelUI)FreeColSelectedPanelUI.createUI(panel));
            } else {
                panel = new MigPanel(new MigLayout("", "[fill]"));
                panel.setOpaque(false);
            }
            Dimension largestIconSize = this.largestIconSize(list);
            panel.add((Component)imageLabel, "center, width " + largestIconSize.width + "px!, height " + largestIconSize.height + "px!");
            panel.add((Component)nameLabel, "split 2, flowy, grow");
            panel.add((Component)locationLabel, "grow");
            return panel;
        }

        private Dimension largestIconSize(JList<? extends UnitWrapper> list) {
            ListModel<? extends UnitWrapper> model = list.getModel();
            int largestWidth = 0;
            int largestHeight = 0;
            for (int i = 0; i < model.getSize(); ++i) {
                UnitWrapper value = model.getElementAt(i);
                BufferedImage image = EndTurnDialog.this.getImageLibrary().getSmallerUnitImage(value.unit);
                if (image.getWidth() > largestWidth) {
                    largestWidth = image.getWidth();
                }
                if (image.getHeight() <= largestHeight) continue;
                largestHeight = image.getHeight();
            }
            return new Dimension(largestWidth, largestHeight);
        }
    }

    private static class UnitWrapper {
        public final Unit unit;
        public final String name;
        public final String location;

        public UnitWrapper(Unit unit) {
            this.unit = unit;
            this.name = unit.getDescription(Unit.UnitLabelType.NATIONAL);
            this.location = Messages.message(unit.getLocation().getLocationLabelFor(unit.getOwner()));
        }

        public String toString() {
            return this.name;
        }
    }
}

