/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.mapviewer;

import java.awt.event.ActionListener;
import java.util.List;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.mapviewer.ChatDisplay;
import net.sf.freecol.client.gui.mapviewer.GUIMessage;
import net.sf.freecol.client.gui.mapviewer.TerrainCursor;
import net.sf.freecol.client.gui.mapviewer.UnitAnimator;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;

public final class MapViewerState {
    private TerrainCursor cursor;
    private PathNode gotoPath = null;
    private PathNode unitPath = null;
    private GUI.ViewMode viewMode = GUI.ViewMode.MOVE_UNITS;
    private Tile selectedTile;
    private Unit activeUnit;
    private boolean rangedAttackMode = false;
    private final ChatDisplay chatDisplay;
    private final UnitAnimator unitAnimator;

    MapViewerState(ChatDisplay chatDisplay, UnitAnimator unitAnimator, ActionListener al) {
        this.cursor = new TerrainCursor();
        this.cursor.addActionListener(al);
        this.chatDisplay = chatDisplay;
        this.unitAnimator = unitAnimator;
    }

    public void setRangedAttackMode(boolean rangedAttackMode) {
        this.rangedAttackMode = rangedAttackMode;
    }

    public boolean isRangedAttackMode() {
        return this.rangedAttackMode;
    }

    public void setCursorBlinking(boolean cursorBlinking) {
        if (cursorBlinking) {
            this.cursor.startBlinking();
        } else {
            this.cursor.stopBlinking();
        }
    }

    public void displayChat(GUIMessage message) {
        this.chatDisplay.addMessage(message);
    }

    public Unit findUnitInFront(Tile unitTile) {
        Unit result;
        if (unitTile == null || unitTile.isEmpty()) {
            result = null;
        } else if (this.activeUnit != null && this.activeUnit.getTile() == unitTile && !this.unitAnimator.isOutForAnimation(this.activeUnit)) {
            result = this.activeUnit;
        } else if (unitTile.hasSettlement()) {
            result = null;
        } else if (this.activeUnit != null && this.activeUnit.isOffensiveUnit()) {
            result = unitTile.getDefendingUnit(this.activeUnit);
        } else {
            result = null;
            List<Unit> units = unitTile.getUnitList();
            int bestScore = -1;
            while (!units.isEmpty()) {
                Unit u = units.remove(0);
                if (this.unitAnimator.isOutForAnimation(u)) continue;
                boolean active = u.getState() == Unit.UnitState.ACTIVE;
                int score = u.getMovesLeft() + (active ? 10000 : 0);
                if (bestScore >= score) continue;
                bestScore = score;
                result = u;
            }
        }
        return result;
    }

    public boolean changeGotoPath(PathNode gotoPath) {
        if (this.gotoPath == gotoPath) {
            return false;
        }
        this.gotoPath = gotoPath;
        this.rangedAttackMode = false;
        return true;
    }

    public PathNode getGotoPath() {
        return this.gotoPath;
    }

    public void setUnitPath(PathNode path) {
        this.unitPath = path;
        this.rangedAttackMode = false;
    }

    public GUI.ViewMode getViewMode() {
        return this.viewMode;
    }

    public void setViewMode(GUI.ViewMode vm) {
        this.viewMode = vm;
        this.rangedAttackMode = false;
    }

    public Unit getActiveUnit() {
        return this.activeUnit;
    }

    public void setActiveUnit(Unit activeUnit) {
        this.activeUnit = activeUnit;
        this.rangedAttackMode = false;
    }

    public Tile getSelectedTile() {
        return this.selectedTile;
    }

    public void setSelectedTile(Tile tile) {
        this.selectedTile = tile;
        this.rangedAttackMode = false;
    }

    public Tile getCursorTile() {
        Tile ret = null;
        switch (this.viewMode) {
            case MOVE_UNITS: {
                if (this.activeUnit == null) break;
                ret = this.activeUnit.getTile();
                break;
            }
            case TERRAIN: {
                ret = this.selectedTile;
                break;
            }
        }
        return ret;
    }

    public UnitAnimator getUnitAnimator() {
        return this.unitAnimator;
    }

    ChatDisplay getChatDisplay() {
        return this.chatDisplay;
    }

    PathNode getUnitPath() {
        return this.unitPath;
    }

    TerrainCursor getCursor() {
        return this.cursor;
    }
}

