/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.TransferHandler;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.label.AbstractGoodsLabel;
import net.sf.freecol.client.gui.label.Draggable;
import net.sf.freecol.client.gui.label.GoodsLabel;
import net.sf.freecol.client.gui.label.GoodsTypeLabel;
import net.sf.freecol.client.gui.label.MarketLabel;
import net.sf.freecol.client.gui.label.UnitLabel;
import net.sf.freecol.client.gui.panel.CargoPanel;
import net.sf.freecol.client.gui.panel.DropTarget;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.GoodsTypePanel;
import net.sf.freecol.client.gui.panel.ImageSelection;
import net.sf.freecol.client.gui.panel.InPortPanel;
import net.sf.freecol.client.gui.panel.PortPanel;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsLocation;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.ImageUtils;

public final class DefaultTransferHandler
extends TransferHandler {
    private static final Logger logger = Logger.getLogger(DefaultTransferHandler.class.getName());
    public static final DataFlavor flavor = new DataFlavor(ImageSelection.class, "ImageSelection");
    private static final FreeColDragGestureRecognizer recognizer = new FreeColDragGestureRecognizer(new FreeColDragHandler());
    private final FreeColClient freeColClient;
    private final FreeColPanel parentPanel;

    public DefaultTransferHandler(FreeColClient freeColClient, FreeColPanel parentPanel) {
        this.freeColClient = freeColClient;
        this.parentPanel = parentPanel;
    }

    private JComponent getDropTarget(JComponent component) {
        return component instanceof DropTarget ? component : (component.getParent() instanceof JComponent ? this.getDropTarget((JComponent)component.getParent()) : null);
    }

    private void restoreSelection(UnitLabel oldSelectedUnit) {
        if (oldSelectedUnit != null && oldSelectedUnit.getParent() instanceof InPortPanel) {
            ((PortPanel)this.parentPanel).setSelectedUnitLabel(oldSelectedUnit);
        }
    }

    private boolean equipUnitIfPossible(UnitLabel unitLabel, AbstractGoods goods) {
        Unit unit = unitLabel.getUnit();
        if (!unit.hasAbility("model.ability.canBeEquipped") || unit.getRole().hasAbility("model.ability.establishMission")) {
            return false;
        }
        for (Role role : CollectionUtils.transform(unit.getAvailableRoles(null), r -> !r.isDefaultRole())) {
            int count;
            List<AbstractGoods> required = unit.getGoodsDifference(role, 1);
            if (required.size() != 1 || required.get(0).getType() != goods.getType() || (count = Math.min(role.getMaximumCount(), goods.getAmount() / required.get(0).getAmount())) <= 0 || role == unit.getRole() && count == unit.getRoleCount()) continue;
            this.freeColClient.getInGameController().equipUnitForRole(unit, role, count);
            unitLabel.updateIcon();
            return true;
        }
        return false;
    }

    private int getAmount(GoodsType goodsType, int available, int defaultAmount, boolean needToPay) {
        return this.freeColClient.getGUI().showSelectAmountDialog(goodsType, available, defaultAmount, needToPay);
    }

    private boolean importFail(JComponent comp, String data) {
        logger.warning("Transfer of " + data + " invalid at: " + comp);
        return false;
    }

    private boolean importGoodsType(JComponent comp, GoodsTypeLabel label) {
        if (comp instanceof GoodsTypePanel) {
            GoodsTypePanel gtp = (GoodsTypePanel)comp;
            GoodsType gt = label.getType();
            if (!gtp.accepts(gt)) {
                return this.importFail(gtp, "unacceptable goods type: " + gt);
            }
            return gtp.add((Component)label, false) != null;
        }
        return false;
    }

    private boolean importGoods(JComponent comp, GoodsLabel label, UnitLabel oldSelectedUnit) {
        Goods goods = label.getGoods();
        if (!(comp instanceof UnitLabel) && !(comp instanceof DropTarget)) {
            return this.importFail(comp, "goods");
        }
        if (label.isSuperFullChosen()) {
            if (goods.getLocation() instanceof GoodsLocation) {
                DropTarget dt;
                GoodsLocation loc = (GoodsLocation)goods.getLocation();
                int amountToTransfer = loc.getGoodsCount(goods.getType());
                if (comp instanceof DropTarget && (dt = (DropTarget)((Object)comp)) instanceof CargoPanel) {
                    CargoPanel cp = (CargoPanel)dt;
                    Unit carrier = cp.getCarrier();
                    int spaceTaken = carrier.getCargoSpaceTaken();
                    int availableHolds = carrier.getCargoCapacity() - spaceTaken;
                    if (amountToTransfer > 100 * availableHolds) {
                        amountToTransfer = 100 * availableHolds;
                        label.setAmount(amountToTransfer);
                    }
                }
            }
        } else if (label.isPartialChosen()) {
            int amount;
            int alt;
            int defaultAmount = goods.getAmount();
            if (goods.getLocation() instanceof GoodsLocation) {
                GoodsLocation loc = (GoodsLocation)goods.getLocation();
                if (goods.getAmount() > loc.getGoodsCapacity()) {
                    defaultAmount = Math.min(100, goods.getAmount() - loc.getGoodsCapacity());
                }
            }
            if (comp instanceof DropTarget && (alt = ((DropTarget)((Object)comp)).suggested(goods.getType())) >= 0 && alt < defaultAmount) {
                defaultAmount = alt;
            }
            if (comp instanceof DropTarget) {
                int origAmount = goods.getAmount();
                DropTarget target = (DropTarget)((Object)comp);
                goods.setAmount(defaultAmount);
                if (defaultAmount <= 0 || !target.accepts(goods)) {
                    return this.importFail(comp, "unacceptable goods pre dialog (" + goods + ")");
                }
                goods.setAmount(origAmount);
            }
            if ((amount = this.getAmount(goods.getType(), goods.getAmount(), defaultAmount, false)) <= 0) {
                return this.importFail(comp, "weird goods amount (" + amount + ")");
            }
            goods.setAmount(amount);
        } else if (!label.isFullChosen() && goods.getAmount() > 100) {
            goods.setAmount(100);
        }
        if (comp instanceof UnitLabel) {
            return this.equipUnitIfPossible((UnitLabel)comp, goods);
        }
        if (comp instanceof DropTarget) {
            DropTarget target = (DropTarget)((Object)comp);
            if (!target.accepts(goods)) {
                return this.importFail(comp, "unacceptable goods (" + goods + ")");
            }
            target.add(label, true);
            this.restoreSelection(oldSelectedUnit);
            comp.revalidate();
            return true;
        }
        return this.importFail(comp, "goods");
    }

    private boolean importMarket(JComponent comp, MarketLabel label) {
        if (!(comp instanceof UnitLabel) && !(comp instanceof CargoPanel)) {
            return false;
        }
        if (label.isPartialChosen()) {
            int amount;
            if (comp instanceof CargoPanel) {
                CargoPanel cargoPanel = (CargoPanel)comp;
                if (cargoPanel.getCarrier() == null) {
                    return false;
                }
                if (cargoPanel.getCarrier().getLoadableAmount(label.getType()) <= 0) {
                    return false;
                }
            }
            if ((amount = this.getAmount(label.getType(), label.getAmount(), -1, true)) <= 0) {
                return false;
            }
            label.setAmount(amount);
        }
        if (comp instanceof UnitLabel) {
            if (this.equipUnitIfPossible((UnitLabel)comp, label.getAbstractGoods())) {
                return true;
            }
            if (comp.getParent() instanceof JComponent) {
                comp = (JComponent)comp.getParent();
            } else {
                return this.importFail(comp, "equipping market goods");
            }
        }
        if (comp instanceof CargoPanel) {
            ((CargoPanel)comp).add((Component)label, true);
            comp.revalidate();
            return true;
        }
        return this.importFail(comp, "market goods");
    }

    private boolean importUnit(JComponent comp, UnitLabel label, UnitLabel oldSelectedUnit) {
        if (!(comp instanceof DropTarget)) {
            return this.importFail(comp, "unit");
        }
        DropTarget target = (DropTarget)((Object)comp);
        Unit unit = label.getUnit();
        if (!target.accepts(unit)) {
            return this.importFail(comp, "unacceptable unit (" + unit + ")");
        }
        target.add(label, true);
        this.restoreSelection(oldSelectedUnit);
        comp.revalidate();
        return true;
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] flavor) {
        return (comp instanceof JPanel || comp instanceof JLabel) && CollectionUtils.any(flavor, CollectionUtils.matchKeyEquals(DefaultTransferHandler.flavor));
    }

    @Override
    public Transferable createTransferable(JComponent comp) {
        return comp instanceof JLabel ? new ImageSelection((JLabel)comp) : null;
    }

    @Override
    public void exportAsDrag(JComponent comp, InputEvent e, int action) {
        int dragAction;
        int srcActions = this.getSourceActions(comp);
        int n = dragAction = e instanceof MouseEvent ? srcActions & action : 0;
        if (dragAction != 0) {
            recognizer.gestured(comp, (MouseEvent)e, srcActions, dragAction);
        } else {
            this.exportDone(comp, null, 0);
        }
    }

    @Override
    public int getSourceActions(JComponent comp) {
        return 3;
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        boolean ret;
        if (!t.isDataFlavorSupported(flavor)) {
            return this.importFail(comp, "data flavor");
        }
        UnitLabel oldSelectedUnit = null;
        try {
            JLabel data = (JLabel)t.getTransferData(flavor);
            if (comp == data) {
                return false;
            }
            if (comp instanceof AbstractGoodsLabel || comp instanceof GoodsTypeLabel) {
                comp = this.getDropTarget(comp);
            } else if (comp instanceof UnitLabel) {
                UnitLabel unitLabel = (UnitLabel)comp;
                if (unitLabel.getUnit().isCarrier() && unitLabel.getParent() instanceof InPortPanel && this.parentPanel instanceof PortPanel) {
                    PortPanel portPanel = (PortPanel)this.parentPanel;
                    if (data instanceof Draggable && ((Draggable)((Object)data)).isOnCarrier()) {
                        oldSelectedUnit = portPanel.getSelectedUnitLabel();
                    }
                    portPanel.setSelectedUnitLabel(unitLabel);
                    comp = portPanel.getCargoPanel();
                } else if (!(data instanceof AbstractGoodsLabel) || !unitLabel.getUnit().hasAbility("model.ability.canBeEquipped")) {
                    comp = this.getDropTarget(comp);
                }
            }
            ret = data.getParent() == comp ? this.importFail(comp, "data-already-present") : (data instanceof GoodsTypeLabel ? this.importGoodsType(comp, (GoodsTypeLabel)data) : (data instanceof GoodsLabel ? this.importGoods(comp, (GoodsLabel)data, oldSelectedUnit) : (data instanceof MarketLabel ? this.importMarket(comp, (MarketLabel)data) : (data instanceof UnitLabel ? this.importUnit(comp, (UnitLabel)data, oldSelectedUnit) : this.importFail(comp, data.toString())))));
        }
        catch (Exception e) {
            ret = this.importFail(comp, "crash: " + e);
        }
        return ret;
    }

    private static class FreeColDragGestureRecognizer
    extends DragGestureRecognizer {
        FreeColDragGestureRecognizer(DragGestureListener dgl) {
            super(DragSource.getDefaultDragSource(), null, 0, dgl);
        }

        public void gestured(JComponent c, MouseEvent e, int srcActions, int action) {
            this.setComponent(c);
            this.setSourceActions(srcActions);
            this.appendEvent(e);
            this.fireDragGestureRecognized(action, e.getPoint());
        }

        @Override
        protected void registerListeners() {
        }

        @Override
        protected void unregisterListeners() {
        }
    }

    private static class FreeColDragHandler
    implements DragGestureListener,
    DragSourceListener {
        private boolean scrolls;

        private FreeColDragHandler() {
        }

        private void updatePartialChosen(JComponent comp, boolean partial) {
            if (comp instanceof AbstractGoodsLabel && partial) {
                ((AbstractGoodsLabel)comp).setAmountType(AbstractGoodsLabel.AmountType.PARTIAL);
            }
        }

        private Cursor getCursor(JComponent c) {
            if (c instanceof JLabel && ((JLabel)c).getIcon() instanceof ImageIcon) {
                Toolkit tk = Toolkit.getDefaultToolkit();
                ImageIcon imageIcon = (ImageIcon)((JLabel)c).getIcon();
                Dimension bestSize = tk.getBestCursorSize(imageIcon.getIconWidth(), imageIcon.getIconHeight());
                if (bestSize.width == 0 || bestSize.height == 0) {
                    return null;
                }
                if (bestSize.width > bestSize.height) {
                    bestSize.height = (int)((double)bestSize.width / (double)imageIcon.getIconWidth() * (double)imageIcon.getIconHeight());
                } else {
                    bestSize.width = (int)((double)bestSize.height / (double)imageIcon.getIconHeight() * (double)imageIcon.getIconWidth());
                }
                BufferedImage scaled = ImageUtils.createResizedImage(imageIcon.getImage(), bestSize.width, bestSize.height);
                Point point = new Point(bestSize.width / 2, bestSize.height / 2);
                return tk.createCustomCursor(scaled, point, "freeColDragIcon");
            }
            return null;
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            JComponent c = (JComponent)dge.getComponent();
            DefaultTransferHandler th = (DefaultTransferHandler)c.getTransferHandler();
            Transferable t = th.createTransferable(c);
            if (t == null) {
                logger.warning("Unable to create transferable for: " + dge);
                th.exportDone(c, null, 0);
                return;
            }
            this.scrolls = c.getAutoscrolls();
            c.setAutoscrolls(false);
            try {
                Cursor cursor = this.getCursor(c);
                dge.startDrag(cursor, t, this);
            }
            catch (RuntimeException re) {
                c.setAutoscrolls(this.scrolls);
            }
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dsde) {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            DragSourceContext dsc = dsde.getDragSourceContext();
            JComponent c = (JComponent)dsc.getComponent();
            if (c.getTransferHandler() instanceof DefaultTransferHandler) {
                DefaultTransferHandler dth = (DefaultTransferHandler)c.getTransferHandler();
                if (dsde.getDropSuccess()) {
                    dth.exportDone(c, dsc.getTransferable(), dsde.getDropAction());
                } else {
                    dth.exportDone(c, null, 0);
                }
                c.setAutoscrolls(this.scrolls);
            }
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
            DragSourceContext dsc = dsde.getDragSourceContext();
            JComponent comp = (JComponent)dsc.getComponent();
            this.updatePartialChosen(comp, dsde.getUserAction() == 2);
        }
    }
}

