/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;

public class AttackMessage
extends AttributeMessage {
    public static final String TAG = "attack";
    private static final String DIRECTION_TAG = "direction";
    private static final String UNIT_TAG = "unit";

    public AttackMessage(Unit unit, Direction direction) {
        super(TAG, UNIT_TAG, unit.getId(), DIRECTION_TAG, String.valueOf(direction));
    }

    public AttackMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, UNIT_TAG, DIRECTION_TAG);
    }

    @Override
    public boolean currentPlayerMessage() {
        return true;
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        Tile tile;
        Unit unit;
        String unitId = this.getStringAttribute(UNIT_TAG);
        String directionString = this.getStringAttribute(DIRECTION_TAG);
        try {
            unit = serverPlayer.getOurFreeColGameObject(unitId, Unit.class);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        if (unit.getMovesLeft() <= 0) {
            return serverPlayer.clientError("No moves left.");
        }
        try {
            tile = unit.getNeighbourTile(directionString);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        Unit.MoveType moveType = unit.getMoveType(tile);
        if (moveType != Unit.MoveType.ENTER_INDIAN_SETTLEMENT_WITH_SCOUT && moveType != Unit.MoveType.ENTER_FOREIGN_COLONY_WITH_SCOUT && !moveType.isAttack()) {
            return serverPlayer.clientError("Illegal attack move for: " + unitId + " type: " + moveType + " from: " + unit.getLocation().getId() + " to: " + tile.getId());
        }
        Unit defender = tile.getDefendingUnit(unit);
        if (defender == null) {
            return serverPlayer.clientError("Could not find defender in tile: " + tile.getId() + " from: " + unit.getLocation().getId());
        }
        return this.igc(freeColServer).combat(serverPlayer, unit, defender, null);
    }
}

