/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;

public class EmigrateUnitMessage
extends AttributeMessage {
    public static final String TAG = "emigrateUnit";
    private static final String SLOT_TAG = "slot";

    public EmigrateUnitMessage(int slot) {
        super(TAG, SLOT_TAG, String.valueOf(slot));
    }

    public EmigrateUnitMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, SLOT_TAG);
    }

    @Override
    public boolean currentPlayerMessage() {
        return true;
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        Europe.MigrationType type;
        int slot;
        String slotString = this.getStringAttribute(SLOT_TAG);
        Europe europe = serverPlayer.getEurope();
        if (europe == null) {
            return serverPlayer.clientError("No Europe to migrate from.");
        }
        try {
            slot = Integer.parseInt(slotString);
        }
        catch (NumberFormatException e) {
            return serverPlayer.clientError("Bad slot: " + slotString);
        }
        if (!Europe.MigrationType.validMigrantSlot(slot)) {
            return serverPlayer.clientError("Invalid slot for recruitment: " + slot);
        }
        if (serverPlayer.getRemainingEmigrants() > 0) {
            if (Europe.MigrationType.unspecificMigrantSlot(slot)) {
                return serverPlayer.clientError("Specific slot expected for FoY migration");
            }
            type = Europe.MigrationType.FOUNTAIN;
        } else if (serverPlayer.checkEmigrate()) {
            if (Europe.MigrationType.specificMigrantSlot(slot) && !serverPlayer.hasAbility("model.ability.selectRecruit")) {
                return serverPlayer.clientError("selectRecruit ability absent");
            }
            type = Europe.MigrationType.NORMAL;
        } else {
            int cost = europe.getCurrentRecruitPrice();
            if (!serverPlayer.checkGold(cost)) {
                return serverPlayer.clientError("No migrants available at cost " + cost + " for player with " + serverPlayer.getGold() + " gold");
            }
            type = Europe.MigrationType.RECRUIT;
        }
        return this.igc(freeColServer).emigrate(serverPlayer, slot, type);
    }
}

