/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.model.ServerPlayer;

public class NativeGiftMessage
extends AttributeMessage {
    public static final String TAG = "nativeGift";
    private static final String COLONY_TAG = "colony";
    private static final String UNIT_TAG = "unit";

    public NativeGiftMessage(Unit unit, Colony colony) {
        super(TAG, UNIT_TAG, unit.getId(), COLONY_TAG, colony.getId());
    }

    public NativeGiftMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, UNIT_TAG, COLONY_TAG);
    }

    @Override
    public boolean currentPlayerMessage() {
        return true;
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public void aiHandler(FreeColServer freeColServer, AIPlayer aiPlayer) {
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        Colony colony;
        Unit unit;
        String unitId = this.getStringAttribute(UNIT_TAG);
        String colonyId = this.getStringAttribute(COLONY_TAG);
        try {
            unit = serverPlayer.getOurFreeColGameObject(unitId, Unit.class);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        try {
            colony = unit.getAdjacentSettlement(colonyId, Colony.class);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        return this.igc(freeColServer).nativeGift(serverPlayer, unit, colony);
    }
}

