/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.networking;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.networking.MessageHandler;
import net.sf.freecol.server.FreeColServer;

public final class Server
extends Thread {
    private static final Logger logger = Logger.getLogger(Server.class.getName());
    private static final int BACKLOG_DEFAULT = 10;
    private final ServerSocket serverSocket;
    private final HashMap<Socket, Connection> connections = new HashMap();
    private boolean running = true;
    private final FreeColServer freeColServer;
    private final String host;
    private final int port;
    private final Object shutdownLock = new Object();

    public Server(FreeColServer freeColServer, String host, int port) throws IOException {
        super("FreeColServer:Server");
        this.freeColServer = freeColServer;
        this.host = host;
        this.port = port;
        this.serverSocket = new ServerSocket(port, 10, InetAddress.getByName(host));
        this.serverSocket.setReuseAddress(true);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(Socket socket) {
        HashMap<Socket, Connection> hashMap = this.connections;
        synchronized (hashMap) {
            return this.connections.get(socket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDummyConnection(Connection connection) {
        if (!this.running) {
            return;
        }
        HashMap<Socket, Connection> hashMap = this.connections;
        synchronized (hashMap) {
            this.connections.put(new Socket(), connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(Connection connection) {
        if (!this.running) {
            return;
        }
        HashMap<Socket, Connection> hashMap = this.connections;
        synchronized (hashMap) {
            this.connections.put(connection.getSocket(), connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(Connection connection) {
        HashMap<Socket, Connection> hashMap = this.connections;
        synchronized (hashMap) {
            this.connections.remove(connection.getSocket());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageHandlerToAllConnections(MessageHandler mh) {
        HashMap<Socket, Connection> hashMap = this.connections;
        synchronized (hashMap) {
            for (Connection c : this.connections.values()) {
                c.setMessageHandler(mh);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendToAll(Message message, Connection exceptConnection) {
        Collection<Connection> currentConnections;
        HashMap<Socket, Connection> hashMap = this.connections;
        synchronized (hashMap) {
            currentConnections = this.connections.values();
        }
        for (Connection conn : currentConnections) {
            if (conn == exceptConnection) continue;
            if (conn.isAlive()) {
                try {
                    conn.sendMessage(message);
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "Unable to send to: " + conn, ex);
                }
                continue;
            }
            logger.log(Level.INFO, "Reap dead connection: " + conn);
            this.removeConnection(conn);
        }
    }

    public void setCommsLogging(boolean log) {
        for (Connection conn : this.connections.values()) {
            conn.setCommsLogging(log);
        }
    }

    public void sendToAll(Message message) {
        this.sendToAll(message, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Object object = this.shutdownLock;
        synchronized (object) {
            while (this.running) {
                try {
                    Socket sock = this.serverSocket.accept();
                    if (sock == null) continue;
                    this.freeColServer.addNewUserConnection(sock);
                }
                catch (Exception ex) {
                    if (!this.running) continue;
                    logger.log(Level.WARNING, "Connection failed: ", ex);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ArrayList<Connection> oldConnections;
        this.running = false;
        try {
            this.serverSocket.close();
            logger.fine("Closed server socket.");
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not close the server socket!", e);
        }
        Object e = this.shutdownLock;
        synchronized (e) {
            logger.fine("Wait for Server.run to complete.");
        }
        HashMap<Socket, Connection> hashMap = this.connections;
        synchronized (hashMap) {
            oldConnections = new ArrayList<Connection>(this.connections.values());
        }
        for (Connection c : oldConnections) {
            if (!c.isAlive()) continue;
            c.disconnect();
        }
        hashMap = this.connections;
        synchronized (hashMap) {
            this.connections.clear();
        }
        this.freeColServer.removeFromMetaServer();
        logger.fine("Server shutdown.");
    }
}

