/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mcpserver.toolsets.vcs;

import com.intellij.mcpserver.McpToolset;
import com.intellij.mcpserver.ProjectContextElementKt;
import com.intellij.mcpserver.annotations.McpDescription;
import com.intellij.mcpserver.annotations.McpTool;
import com.intellij.mcpserver.util.Fs_utilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitCommit;
import git4idea.history.GitHistoryUtils;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u0005H\u0087@\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\b\u001a\u00020\u0005H\u0087@\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/mcpserver/toolsets/vcs/VcsToolset;", "Lcom/intellij/mcpserver/McpToolset;", "<init>", "()V", "find_commit_by_message", "", "text", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "get_project_vcs_status", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.mcpserver"})
@SourceDebugExtension(value={"SMAP\nVcsToolset.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsToolset.kt\ncom/intellij/mcpserver/toolsets/vcs/VcsToolset\n+ 2 CoroutineScope.kt\nkotlinx/coroutines/CoroutineScopeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n374#2:119\n374#2:137\n11546#3,9:120\n13472#3:129\n13473#3:131\n11555#3:132\n1#4:130\n1869#5:133\n1869#5,2:134\n1870#5:136\n1869#5,2:138\n1869#5,2:140\n*S KotlinDebug\n*F\n+ 1 VcsToolset.kt\ncom/intellij/mcpserver/toolsets/vcs/VcsToolset\n*L\n29#1:119\n80#1:137\n35#1:120,9\n35#1:129\n35#1:131\n35#1:132\n35#1:130\n42#1:133\n48#1:134,2\n42#1:136\n90#1:138,2\n105#1:140,2\n*E\n"})
public final class VcsToolset
implements McpToolset {
    /*
     * WARNING - void declaration
     */
    @McpTool
    @McpDescription(description="\n        Searches for a commit based on the provided text or keywords in the project history.\n        Useful for finding specific change sets or code modifications by commit messages or diff content.\n        Takes a query parameter and returns the matching commit information.\n        Returns matched commit hashes as a JSON array.\n    ")
    @Nullable
    public final Object find_commit_by_message(@McpDescription(description="Text or keywords to search for in commit messages") @NotNull String text, @NotNull Continuation<? super String> $completion) {
        boolean $i$f$currentCoroutineContext = false;
        Project project = ProjectContextElementKt.getProject($completion.getContext());
        String queryText = text;
        List matchingCommits = new ArrayList();
        try {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            VcsRoot[] vcsRootArray = ProjectLevelVcsManager.getInstance((Project)project).getAllVcsRoots();
            Intrinsics.checkNotNullExpressionValue((Object)vcsRootArray, (String)"getAllVcsRoots(...)");
            Object[] objectArray = vcsRootArray;
            boolean $i$f$mapNotNull = false;
            Iterator iterator = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                VirtualFile it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                VcsRoot it = (VcsRoot)element$iv$iv;
                boolean bl2 = false;
                if (it.getPath() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List vcs = (List)destination$iv$iv;
            if (vcs.isEmpty()) {
                return "Error: No VCS configured for this project";
            }
            Iterable $this$forEach$iv = vcs;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                List gitLog;
                GitRepository repository;
                VirtualFile vcsRoot = (VirtualFile)element$iv;
                boolean bl = false;
                if ((GitRepository)GitRepositoryManager.getInstance((Project)project).getRepositoryForRoot(vcsRoot) == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)GitHistoryUtils.history((Project)project, (VirtualFile)repository.getRoot(), (String[])new String[0]), (String)"history(...)");
                Iterable $this$forEach$iv2 = gitLog;
                boolean $i$f$forEach3 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    GitCommit commit = (GitCommit)element$iv2;
                    boolean bl4 = false;
                    String string = commit.getFullMessage();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullMessage(...)");
                    if (!StringsKt.contains((CharSequence)string, (CharSequence)queryText, (boolean)true)) continue;
                    matchingCommits.add(commit.getId().toString());
                }
            }
            return !((Collection)matchingCommits).isEmpty() ? CollectionsKt.joinToString$default((Iterable)matchingCommits, (CharSequence)",", (CharSequence)"[", (CharSequence)"]", (int)0, null, VcsToolset::find_commit_by_message$lambda$3, (int)24, null) : "No commits found matching the query: " + queryText;
        }
        catch (Exception e) {
            return "Error while searching commits: " + e.getMessage();
        }
    }

    @McpTool
    @McpDescription(description="\n        Retrieves the current version control status of files in the project.\n        Use this tool to get information about modified, added, deleted, and moved files in your VCS (e.g., Git).\n        Returns a JSON-formatted list of changed files, where each entry contains:\n        - path: The file path relative to project root\n        - type: The type of change (e.g., MODIFICATION, ADDITION, DELETION, MOVED)\n        Returns an empty list ([]) if no changes are detected or VCS is not configured.\n        Returns error \"project dir not found\" if project directory cannot be determined.\n        Note: Works with any VCS supported by the IDE, but is most commonly used with Git\n    ")
    @Nullable
    public final Object get_project_vcs_status(@NotNull Continuation<? super String> $completion) {
        boolean $i$f$currentCoroutineContext = false;
        Project project = ProjectContextElementKt.getProject($completion.getContext());
        Path projectDir = Fs_utilKt.getProjectDirectory(project);
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
        ChangeListManager changeListManager2 = changeListManager;
        Collection collection = changeListManager2.getAllChanges();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAllChanges(...)");
        Collection changes = collection;
        List list = changeListManager2.getUnversionedFilesPaths();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getUnversionedFilesPaths(...)");
        List unversionedFiles = list;
        List result2 = new ArrayList();
        Iterable $this$forEach$iv = changes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Change change = (Change)element$iv;
            boolean bl = false;
            Object object = change.getVirtualFile();
            if (object == null || (object = object.getPath()) == null) {
                ContentRevision contentRevision = change.getAfterRevision();
                object = contentRevision != null && (contentRevision = contentRevision.getFile()) != null ? contentRevision.getPath() : null;
            }
            Object absolutePath = object;
            Intrinsics.checkNotNullExpressionValue((Object)change.getType(), (String)"getType(...)");
            if (absolutePath == null) continue;
            try {
                Change.Type changeType;
                Path path = Paths.get((String)absolutePath, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                String relativePath = ((Object)projectDir.relativize(path)).toString();
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"path", (Object)relativePath), TuplesKt.to((Object)"type", (Object)changeType.toString())};
                result2.add(MapsKt.mapOf((Pair[])pairArray));
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        $this$forEach$iv = unversionedFiles;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FilePath file = (FilePath)element$iv;
            boolean bl = false;
            try {
                String string = file.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                Path path = Paths.get(string, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                String relativePath = ((Object)projectDir.relativize(path)).toString();
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"path", (Object)relativePath), TuplesKt.to((Object)"type", (Object)"UNVERSIONED")};
                result2.add(MapsKt.mapOf((Pair[])pairArray));
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return CollectionsKt.joinToString$default((Iterable)result2, (CharSequence)",\n", (CharSequence)"[", (CharSequence)"]", (int)0, null, VcsToolset::get_project_vcs_status$lambda$6, (int)24, null);
    }

    private static final CharSequence find_commit_by_message$lambda$3(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "\"" + it + "\"";
    }

    private static final CharSequence get_project_vcs_status$lambda$6(Map it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "{\"path\": \"" + it.get("path") + "\", \"type\": \"" + it.get("type") + "\"}";
    }
}

