/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.semantics;

import androidx.compose.ui.semantics.SemanticsRegion;
import androidx.compose.ui.unit.IntRect;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.IRect;
import org.jetbrains.skia.Region;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0004H\u0016J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0001H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Landroidx/compose/ui/semantics/SemanticRegionImpl;", "Landroidx/compose/ui/semantics/SemanticsRegion;", "()V", "bounds", "Landroidx/compose/ui/unit/IntRect;", "getBounds", "()Landroidx/compose/ui/unit/IntRect;", "isEmpty", "", "()Z", "region", "Lorg/jetbrains/skia/Region;", "getRegion", "()Lorg/jetbrains/skia/Region;", "difference", "rect", "intersect", "set", "", "ui"})
final class SemanticRegionImpl
implements SemanticsRegion {
    @NotNull
    private final Region region = new Region();

    @NotNull
    public final Region getRegion() {
        return this.region;
    }

    @Override
    public void set(@NotNull IntRect rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        this.region.setRect(IRect.Companion.makeLTRB(rect.getLeft(), rect.getTop(), rect.getRight(), rect.getBottom()));
    }

    @Override
    @NotNull
    public IntRect getBounds() {
        IRect it = this.region.getBounds();
        boolean bl = false;
        return new IntRect(it.getLeft(), it.getTop(), it.getRight(), it.getBottom());
    }

    @Override
    public boolean isEmpty() {
        return this.region.isEmpty();
    }

    @Override
    public boolean intersect(@NotNull SemanticsRegion region) {
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        return this.region.op(((SemanticRegionImpl)region).region, Region.Op.INTERSECT);
    }

    @Override
    public boolean difference(@NotNull IntRect rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        return this.region.op(IRect.Companion.makeLTRB(rect.getLeft(), rect.getTop(), rect.getRight(), rect.getBottom()), Region.Op.DIFFERENCE);
    }
}

