/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;

public class EnsureNode
extends Node {
    private final Node bodyNode;
    private final Node ensureNode;

    public EnsureNode(int line, Node bodyNode, Node ensureNode) {
        super(line, bodyNode.containsVariableAssignment() || ensureNode != null && ensureNode.containsVariableAssignment());
        this.bodyNode = bodyNode;
        this.ensureNode = ensureNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ENSURENODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitEnsureNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Node getEnsureNode() {
        return this.ensureNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.bodyNode, this.ensureNode);
    }
}

