/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.model;

import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.openapitools.openapidiff.core.model.Changed;
import org.openapitools.openapidiff.core.model.ChangedContent;
import org.openapitools.openapidiff.core.model.ChangedExtensions;
import org.openapitools.openapidiff.core.model.ChangedHeaders;
import org.openapitools.openapidiff.core.model.ChangedMetadata;
import org.openapitools.openapidiff.core.model.ComposedChanged;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.model.DiffResult;

public class ChangedResponse
implements ComposedChanged {
    private final ApiResponse oldApiResponse;
    private final ApiResponse newApiResponse;
    private final DiffContext context;
    private ChangedMetadata description;
    private ChangedHeaders headers;
    private ChangedContent content;
    private ChangedExtensions extensions;

    public ChangedResponse(ApiResponse oldApiResponse, ApiResponse newApiResponse, DiffContext context) {
        this.oldApiResponse = oldApiResponse;
        this.newApiResponse = newApiResponse;
        this.context = context;
    }

    @Override
    public List<Changed> getChangedElements() {
        return Arrays.asList(this.description, this.headers, this.content, this.extensions);
    }

    @Override
    public DiffResult isCoreChanged() {
        return DiffResult.NO_CHANGES;
    }

    public ApiResponse getOldApiResponse() {
        return this.oldApiResponse;
    }

    public ApiResponse getNewApiResponse() {
        return this.newApiResponse;
    }

    public DiffContext getContext() {
        return this.context;
    }

    public ChangedMetadata getDescription() {
        return this.description;
    }

    public ChangedHeaders getHeaders() {
        return this.headers;
    }

    public ChangedContent getContent() {
        return this.content;
    }

    public ChangedExtensions getExtensions() {
        return this.extensions;
    }

    public ChangedResponse setDescription(ChangedMetadata description) {
        this.description = description;
        return this;
    }

    public ChangedResponse setHeaders(ChangedHeaders headers) {
        this.headers = headers;
        return this;
    }

    public ChangedResponse setContent(ChangedContent content) {
        this.content = content;
        return this;
    }

    public ChangedResponse setExtensions(ChangedExtensions extensions) {
        this.extensions = extensions;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangedResponse that = (ChangedResponse)o;
        return Objects.equals(this.oldApiResponse, that.oldApiResponse) && Objects.equals(this.newApiResponse, that.newApiResponse) && Objects.equals(this.context, that.context) && Objects.equals(this.description, that.description) && Objects.equals(this.headers, that.headers) && Objects.equals(this.content, that.content) && Objects.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        return Objects.hash(this.oldApiResponse, this.newApiResponse, this.context, this.description, this.headers, this.content, this.extensions);
    }

    public String toString() {
        return "ChangedResponse(oldApiResponse=" + this.getOldApiResponse() + ", newApiResponse=" + this.getNewApiResponse() + ", context=" + this.getContext() + ", description=" + this.getDescription() + ", headers=" + this.getHeaders() + ", content=" + this.getContent() + ", extensions=" + this.getExtensions() + ")";
    }
}

