/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ingest.useragent;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.ingest.Processor;
import org.opensearch.ingest.useragent.UserAgentCache;
import org.opensearch.ingest.useragent.UserAgentParser;
import org.opensearch.ingest.useragent.UserAgentProcessor;
import org.opensearch.plugins.IngestPlugin;
import org.opensearch.plugins.Plugin;

public class IngestUserAgentModulePlugin
extends Plugin
implements IngestPlugin {
    static final Setting<List<String>> PROCESSORS_ALLOWLIST_SETTING = Setting.listSetting((String)"ingest.useragent.processors.allowed", List.of(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final Setting<Long> CACHE_SIZE_SETTING = Setting.longSetting((String)"ingest.user_agent.cache_size", (long)1000L, (long)0L, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final String DEFAULT_PARSER_NAME = "_default_";

    public Map<String, Processor.Factory> getProcessors(Processor.Parameters parameters) {
        Map<String, UserAgentParser> userAgentParsers;
        Path userAgentConfigDirectory = parameters.env.configDir().resolve("ingest-user-agent");
        if (!Files.exists(userAgentConfigDirectory, new LinkOption[0]) && Files.isDirectory(userAgentConfigDirectory, new LinkOption[0])) {
            throw new IllegalStateException("the user agent directory [" + String.valueOf(userAgentConfigDirectory) + "] containing the regex file doesn't exist");
        }
        long cacheSize = (Long)this.CACHE_SIZE_SETTING.get(parameters.env.settings());
        try {
            userAgentParsers = IngestUserAgentModulePlugin.createUserAgentParsers(userAgentConfigDirectory, new UserAgentCache(cacheSize));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.filterForAllowlistSetting(parameters.env.settings(), Collections.singletonMap("user_agent", new UserAgentProcessor.Factory(userAgentParsers)));
    }

    private Map<String, Processor.Factory> filterForAllowlistSetting(Settings settings, Map<String, Processor.Factory> map) {
        if (!PROCESSORS_ALLOWLIST_SETTING.exists(settings)) {
            return Map.copyOf(map);
        }
        Set allowlist = Set.copyOf((Collection)PROCESSORS_ALLOWLIST_SETTING.get(settings));
        Set unknownAllowlistProcessors = allowlist.stream().filter(p -> !map.containsKey(p)).collect(Collectors.toUnmodifiableSet());
        if (!unknownAllowlistProcessors.isEmpty()) {
            throw new IllegalArgumentException("Processor(s) " + String.valueOf(unknownAllowlistProcessors) + " were defined in [" + PROCESSORS_ALLOWLIST_SETTING.getKey() + "] but do not exist");
        }
        return map.entrySet().stream().filter(e -> allowlist.contains(e.getKey())).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    static Map<String, UserAgentParser> createUserAgentParsers(Path userAgentConfigDirectory, UserAgentCache cache) throws IOException {
        HashMap<String, UserAgentParser> userAgentParsers = new HashMap<String, UserAgentParser>();
        UserAgentParser defaultParser = new UserAgentParser(DEFAULT_PARSER_NAME, IngestUserAgentModulePlugin.class.getResourceAsStream("/regexes.yml"), cache);
        userAgentParsers.put(DEFAULT_PARSER_NAME, defaultParser);
        if (Files.exists(userAgentConfigDirectory, new LinkOption[0]) && Files.isDirectory(userAgentConfigDirectory, new LinkOption[0])) {
            PathMatcher pathMatcher = userAgentConfigDirectory.getFileSystem().getPathMatcher("glob:**.yml");
            try (Stream<Path> regexFiles = Files.find(userAgentConfigDirectory, 1, (path, attr) -> attr.isRegularFile() && pathMatcher.matches((Path)path), new FileVisitOption[0]);){
                Iterable iterable = regexFiles::iterator;
                for (Path path2 : iterable) {
                    String parserName = path2.getFileName().toString();
                    InputStream regexStream = Files.newInputStream(path2, StandardOpenOption.READ);
                    try {
                        userAgentParsers.put(parserName, new UserAgentParser(parserName, regexStream, cache));
                    }
                    finally {
                        if (regexStream == null) continue;
                        regexStream.close();
                    }
                }
            }
        }
        return Collections.unmodifiableMap(userAgentParsers);
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(this.CACHE_SIZE_SETTING, PROCESSORS_ALLOWLIST_SETTING);
    }
}

