/*
 * Decompiled with CFR 0.152.
 */
package com.tdunning.math.stats;

public enum ScaleFunction {
    K_0{

        @Override
        public double k(double q, double compression, double n) {
            return compression * q / 2.0;
        }

        @Override
        public double k(double q, double normalizer) {
            return normalizer * q;
        }

        @Override
        public double q(double k, double compression, double n) {
            return 2.0 * k / compression;
        }

        @Override
        public double q(double k, double normalizer) {
            return k / normalizer;
        }

        @Override
        public double max(double q, double compression, double n) {
            return 2.0 / compression;
        }

        @Override
        public double max(double q, double normalizer) {
            return 1.0 / normalizer;
        }

        @Override
        public double normalizer(double compression, double n) {
            return compression / 2.0;
        }
    }
    ,
    K_1{

        @Override
        public double k(double q, final double compression, double n) {
            Function f = new Function(){

                @Override
                double apply(double q) {
                    return compression * Math.asin(2.0 * q - 1.0) / (Math.PI * 2);
                }
            };
            return ScaleFunction.limitCall(f, q, 1.0E-15, 0.999999999999999);
        }

        @Override
        public double k(double q, final double normalizer) {
            Function f = new Function(){

                @Override
                double apply(double q) {
                    return normalizer * Math.asin(2.0 * q - 1.0);
                }
            };
            return ScaleFunction.limitCall(f, q, 1.0E-15, 0.999999999999999);
        }

        @Override
        public double q(double k, final double compression, double n) {
            Function f = new Function(){

                @Override
                double apply(double k) {
                    return (Math.sin(k * (Math.PI * 2 / compression)) + 1.0) / 2.0;
                }
            };
            return ScaleFunction.limitCall(f, k, -compression / 4.0, compression / 4.0);
        }

        @Override
        public double q(double k, double normalizer) {
            Function f = new Function(){

                @Override
                double apply(double x) {
                    return (Math.sin(x) + 1.0) / 2.0;
                }
            };
            double x = k / normalizer;
            return ScaleFunction.limitCall(f, x, -1.5707963267948966, 1.5707963267948966);
        }

        @Override
        public double max(double q, double compression, double n) {
            if (q <= 0.0) {
                return 0.0;
            }
            if (q >= 1.0) {
                return 0.0;
            }
            return 2.0 * Math.sin(Math.PI / compression) * Math.sqrt(q * (1.0 - q));
        }

        @Override
        public double max(double q, double normalizer) {
            if (q <= 0.0) {
                return 0.0;
            }
            if (q >= 1.0) {
                return 0.0;
            }
            return 2.0 * Math.sin(0.5 / normalizer) * Math.sqrt(q * (1.0 - q));
        }

        @Override
        public double normalizer(double compression, double n) {
            return compression / (Math.PI * 2);
        }
    }
    ,
    K_1_FAST{

        @Override
        public double k(double q, final double compression, double n) {
            Function f = new Function(){

                @Override
                double apply(double q) {
                    return compression * ScaleFunction.fastAsin(2.0 * q - 1.0) / (Math.PI * 2);
                }
            };
            return ScaleFunction.limitCall(f, q, 0.0, 1.0);
        }

        @Override
        public double k(double q, final double normalizer) {
            Function f = new Function(){

                @Override
                double apply(double q) {
                    return normalizer * ScaleFunction.fastAsin(2.0 * q - 1.0);
                }
            };
            return ScaleFunction.limitCall(f, q, 0.0, 1.0);
        }

        @Override
        public double q(double k, double compression, double n) {
            return (Math.sin(k * (Math.PI * 2 / compression)) + 1.0) / 2.0;
        }

        @Override
        public double q(double k, double normalizer) {
            return (Math.sin(k / normalizer) + 1.0) / 2.0;
        }

        @Override
        public double max(double q, double compression, double n) {
            if (q <= 0.0) {
                return 0.0;
            }
            if (q >= 1.0) {
                return 0.0;
            }
            return 2.0 * Math.sin(Math.PI / compression) * Math.sqrt(q * (1.0 - q));
        }

        @Override
        public double max(double q, double normalizer) {
            if (q <= 0.0) {
                return 0.0;
            }
            if (q >= 1.0) {
                return 0.0;
            }
            return 2.0 * Math.sin(0.5 / normalizer) * Math.sqrt(q * (1.0 - q));
        }

        @Override
        public double normalizer(double compression, double n) {
            return compression / (Math.PI * 2);
        }
    }
    ,
    K_2{

        @Override
        public double k(double q, final double compression, final double n) {
            if (n <= 1.0) {
                if (q <= 0.0) {
                    return -10.0;
                }
                if (q >= 1.0) {
                    return 10.0;
                }
                return 0.0;
            }
            Function f = new Function(){

                @Override
                double apply(double q) {
                    return compression * Math.log(q / (1.0 - q)) / this.Z(compression, n);
                }
            };
            return ScaleFunction.limitCall(f, q, 1.0E-15, 0.999999999999999);
        }

        @Override
        public double k(double q, final double normalizer) {
            Function f = new Function(){

                @Override
                double apply(double q) {
                    return Math.log(q / (1.0 - q)) * normalizer;
                }
            };
            return ScaleFunction.limitCall(f, q, 1.0E-15, 0.999999999999999);
        }

        @Override
        public double q(double k, double compression, double n) {
            double w = Math.exp(k * this.Z(compression, n) / compression);
            return w / (1.0 + w);
        }

        @Override
        public double q(double k, double normalizer) {
            double w = Math.exp(k / normalizer);
            return w / (1.0 + w);
        }

        @Override
        public double max(double q, double compression, double n) {
            return this.Z(compression, n) * q * (1.0 - q) / compression;
        }

        @Override
        public double max(double q, double normalizer) {
            return q * (1.0 - q) / normalizer;
        }

        @Override
        public double normalizer(double compression, double n) {
            return compression / this.Z(compression, n);
        }

        private double Z(double compression, double n) {
            return 4.0 * Math.log(n / compression) + 24.0;
        }
    }
    ,
    K_3{

        @Override
        public double k(double q, final double compression, final double n) {
            Function f = new Function(){

                @Override
                double apply(double q) {
                    if (q <= 0.5) {
                        return compression * Math.log(2.0 * q) / this.Z(compression, n);
                    }
                    return -this.k(1.0 - q, compression, n);
                }
            };
            return ScaleFunction.limitCall(f, q, 1.0E-15, 0.999999999999999);
        }

        @Override
        public double k(double q, final double normalizer) {
            Function f = new Function(){

                @Override
                double apply(double q) {
                    if (q <= 0.5) {
                        return Math.log(2.0 * q) * normalizer;
                    }
                    return -this.k(1.0 - q, normalizer);
                }
            };
            return ScaleFunction.limitCall(f, q, 1.0E-15, 0.999999999999999);
        }

        @Override
        public double q(double k, double compression, double n) {
            if (k <= 0.0) {
                return Math.exp(k * this.Z(compression, n) / compression) / 2.0;
            }
            return 1.0 - this.q(-k, compression, n);
        }

        @Override
        public double q(double k, double normalizer) {
            if (k <= 0.0) {
                return Math.exp(k / normalizer) / 2.0;
            }
            return 1.0 - this.q(-k, normalizer);
        }

        @Override
        public double max(double q, double compression, double n) {
            return this.Z(compression, n) * Math.min(q, 1.0 - q) / compression;
        }

        @Override
        public double max(double q, double normalizer) {
            return Math.min(q, 1.0 - q) / normalizer;
        }

        @Override
        public double normalizer(double compression, double n) {
            return compression / this.Z(compression, n);
        }

        private double Z(double compression, double n) {
            return 4.0 * Math.log(n / compression) + 21.0;
        }
    }
    ,
    K_2_NO_NORM{

        @Override
        public double k(double q, final double compression, double n) {
            Function f = new Function(){

                @Override
                double apply(double q) {
                    return compression * Math.log(q / (1.0 - q));
                }
            };
            return ScaleFunction.limitCall(f, q, 1.0E-15, 0.999999999999999);
        }

        @Override
        public double k(double q, final double normalizer) {
            Function f = new Function(){

                @Override
                double apply(double q) {
                    return normalizer * Math.log(q / (1.0 - q));
                }
            };
            return ScaleFunction.limitCall(f, q, 1.0E-15, 0.999999999999999);
        }

        @Override
        public double q(double k, double compression, double n) {
            double w = Math.exp(k / compression);
            return w / (1.0 + w);
        }

        @Override
        public double q(double k, double normalizer) {
            double w = Math.exp(k / normalizer);
            return w / (1.0 + w);
        }

        @Override
        public double max(double q, double compression, double n) {
            return q * (1.0 - q) / compression;
        }

        @Override
        public double max(double q, double normalizer) {
            return q * (1.0 - q) / normalizer;
        }

        @Override
        public double normalizer(double compression, double n) {
            return compression;
        }
    }
    ,
    K_3_NO_NORM{

        @Override
        public double k(double q, final double compression, final double n) {
            Function f = new Function(){

                @Override
                double apply(double q) {
                    if (q <= 0.5) {
                        return compression * Math.log(2.0 * q);
                    }
                    return -this.k(1.0 - q, compression, n);
                }
            };
            return 7.limitCall(f, q, 1.0E-15, 0.999999999999999);
        }

        @Override
        public double k(double q, final double normalizer) {
            Function f = new Function(){

                @Override
                double apply(double q) {
                    if (q <= 0.5) {
                        return normalizer * Math.log(2.0 * q);
                    }
                    return -this.k(1.0 - q, normalizer);
                }
            };
            return 7.limitCall(f, q, 1.0E-15, 0.999999999999999);
        }

        @Override
        public double q(double k, double compression, double n) {
            if (k <= 0.0) {
                return Math.exp(k / compression) / 2.0;
            }
            return 1.0 - this.q(-k, compression, n);
        }

        @Override
        public double q(double k, double normalizer) {
            if (k <= 0.0) {
                return Math.exp(k / normalizer) / 2.0;
            }
            return 1.0 - this.q(-k, normalizer);
        }

        @Override
        public double max(double q, double compression, double n) {
            return Math.min(q, 1.0 - q) / compression;
        }

        @Override
        public double max(double q, double normalizer) {
            return Math.min(q, 1.0 - q) / normalizer;
        }

        @Override
        public double normalizer(double compression, double n) {
            return compression;
        }
    };


    public abstract double k(double var1, double var3, double var5);

    public abstract double k(double var1, double var3);

    public abstract double q(double var1, double var3, double var5);

    public abstract double q(double var1, double var3);

    public abstract double max(double var1, double var3, double var5);

    public abstract double max(double var1, double var3);

    public abstract double normalizer(double var1, double var3);

    static double fastAsin(double x) {
        if (x < 0.0) {
            return -ScaleFunction.fastAsin(-x);
        }
        if (x > 1.0) {
            return Double.NaN;
        }
        double c0High = 0.1;
        double c1High = 0.55;
        double c2Low = 0.5;
        double c2High = 0.8;
        double c3Low = 0.75;
        double c3High = 0.9;
        double c4Low = 0.87;
        if (x > c3High) {
            return Math.asin(x);
        }
        double[] m0 = new double[]{0.2955302411, 1.2221903614, 0.1488583743, 0.2422015816, -0.3688700895, 0.0733398445};
        double[] m1 = new double[]{-0.043099192, 0.959403575, -0.0362312299, 0.1204623351, 0.045702962, -0.0026025285};
        double[] m2 = new double[]{-0.034873933724, 1.054796752703, -0.194127063385, 0.283963735636, 0.023800124916, -8.72727381E-4};
        double[] m3 = new double[]{-0.37588391875, 2.61991859025, -2.48835406886, 1.48605387425, 0.00857627492, -1.5802871E-4};
        double[] vars = new double[]{1.0, x, x * x, x * x * x, 1.0 / (1.0 - x), 1.0 / (1.0 - x) / (1.0 - x)};
        double x0 = ScaleFunction.bound((c0High - x) / c0High);
        double x1 = ScaleFunction.bound((c1High - x) / (c1High - c2Low));
        double x2 = ScaleFunction.bound((c2High - x) / (c2High - c3Low));
        double x3 = ScaleFunction.bound((c3High - x) / (c3High - c4Low));
        double mix0 = x0;
        double mix1 = (1.0 - x0) * x1;
        double mix2 = (1.0 - x1) * x2;
        double mix3 = (1.0 - x2) * x3;
        double mix4 = 1.0 - x3;
        double r = 0.0;
        if (mix0 > 0.0) {
            r += mix0 * ScaleFunction.eval(m0, vars);
        }
        if (mix1 > 0.0) {
            r += mix1 * ScaleFunction.eval(m1, vars);
        }
        if (mix2 > 0.0) {
            r += mix2 * ScaleFunction.eval(m2, vars);
        }
        if (mix3 > 0.0) {
            r += mix3 * ScaleFunction.eval(m3, vars);
        }
        if (mix4 > 0.0) {
            r += mix4 * Math.asin(x);
        }
        return r;
    }

    static double limitCall(Function f, double x, double low, double high) {
        if (x < low) {
            return f.apply(low);
        }
        if (x > high) {
            return f.apply(high);
        }
        return f.apply(x);
    }

    private static double eval(double[] model, double[] vars) {
        double r = 0.0;
        for (int i = 0; i < model.length; ++i) {
            r += model[i] * vars[i];
        }
        return r;
    }

    private static double bound(double v) {
        if (v <= 0.0) {
            return 0.0;
        }
        if (v >= 1.0) {
            return 1.0;
        }
        return v;
    }

    static abstract class Function {
        Function() {
        }

        abstract double apply(double var1);
    }
}

