/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.scale.searchonly;

import java.io.IOException;
import java.util.List;
import org.opensearch.action.admin.indices.scale.searchonly.ScaleIndexShardResponse;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.transport.TransportResponse;

class ScaleIndexNodeResponse
extends TransportResponse {
    private final DiscoveryNode node;
    private final List<ScaleIndexShardResponse> shardResponses;

    ScaleIndexNodeResponse(DiscoveryNode node, List<ScaleIndexShardResponse> shardResponses) {
        this.node = node;
        this.shardResponses = shardResponses;
    }

    ScaleIndexNodeResponse(StreamInput in) throws IOException {
        this.node = new DiscoveryNode(in);
        this.shardResponses = in.readList(ScaleIndexShardResponse::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.node.writeTo(out);
        out.writeList(this.shardResponses);
    }

    public DiscoveryNode getNode() {
        return this.node;
    }

    public List<ScaleIndexShardResponse> getShardResponses() {
        return this.shardResponses;
    }
}

