/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.coordination;

import java.util.EnumSet;
import org.opensearch.cluster.block.ClusterBlock;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.rest.RestStatus;

public class NoClusterManagerBlockService {
    public static final int NO_CLUSTER_MANAGER_BLOCK_ID = 2;
    public static final ClusterBlock NO_CLUSTER_MANAGER_BLOCK_WRITES = new ClusterBlock(2, "no cluster-manager", true, false, false, RestStatus.SERVICE_UNAVAILABLE, EnumSet.of(ClusterBlockLevel.WRITE, ClusterBlockLevel.METADATA_WRITE));
    public static final ClusterBlock NO_CLUSTER_MANAGER_BLOCK_ALL = new ClusterBlock(2, "no cluster-manager", true, true, false, RestStatus.SERVICE_UNAVAILABLE, ClusterBlockLevel.ALL);
    public static final ClusterBlock NO_CLUSTER_MANAGER_BLOCK_METADATA_WRITES = new ClusterBlock(2, "no cluster-manager", true, false, false, RestStatus.SERVICE_UNAVAILABLE, EnumSet.of(ClusterBlockLevel.METADATA_WRITE));
    public static final Setting<ClusterBlock> NO_MASTER_BLOCK_SETTING = new Setting<ClusterBlock>("cluster.no_master_block", "metadata_write", NoClusterManagerBlockService::parseNoClusterManagerBlock, Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Deprecated);
    public static final Setting<ClusterBlock> NO_CLUSTER_MANAGER_BLOCK_SETTING = new Setting<ClusterBlock>("cluster.no_cluster_manager_block", NO_MASTER_BLOCK_SETTING, NoClusterManagerBlockService::parseNoClusterManagerBlock, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile ClusterBlock noClusterManagerBlock;

    public NoClusterManagerBlockService(Settings settings, ClusterSettings clusterSettings) {
        this.noClusterManagerBlock = NO_CLUSTER_MANAGER_BLOCK_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(NO_CLUSTER_MANAGER_BLOCK_SETTING, this::setNoClusterManagerBlock);
    }

    private static ClusterBlock parseNoClusterManagerBlock(String value) {
        switch (value) {
            case "all": {
                return NO_CLUSTER_MANAGER_BLOCK_ALL;
            }
            case "write": {
                return NO_CLUSTER_MANAGER_BLOCK_WRITES;
            }
            case "metadata_write": {
                return NO_CLUSTER_MANAGER_BLOCK_METADATA_WRITES;
            }
        }
        throw new IllegalArgumentException("invalid no-cluster-manager block [" + value + "], must be one of [all, write, metadata_write]");
    }

    public ClusterBlock getNoClusterManagerBlock() {
        return this.noClusterManagerBlock;
    }

    private void setNoClusterManagerBlock(ClusterBlock noClusterManagerBlock) {
        this.noClusterManagerBlock = noClusterManagerBlock;
    }
}

