/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.seqno;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.seqno.RetentionLease;
import org.opensearch.index.seqno.RetentionLeases;

@PublicApi(since="1.0.0")
public final class RetentionLeaseStats
implements ToXContentFragment,
Writeable {
    private final RetentionLeases retentionLeases;

    public RetentionLeases retentionLeases() {
        return this.retentionLeases;
    }

    public RetentionLeaseStats(RetentionLeases retentionLeases) {
        this.retentionLeases = Objects.requireNonNull(retentionLeases);
    }

    public RetentionLeaseStats(StreamInput in) throws IOException {
        this.retentionLeases = new RetentionLeases(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.retentionLeases.writeTo(out);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("retention_leases");
        builder.field("primary_term", this.retentionLeases.primaryTerm());
        builder.field("version", this.retentionLeases.version());
        builder.startArray("leases");
        for (RetentionLease retentionLease : this.retentionLeases.leases()) {
            builder.startObject();
            builder.field("id", retentionLease.id());
            builder.field("retaining_seq_no", retentionLease.retainingSequenceNumber());
            builder.field("timestamp", retentionLease.timestamp());
            builder.field("source", retentionLease.source());
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RetentionLeaseStats that = (RetentionLeaseStats)o;
        return Objects.equals(this.retentionLeases, that.retentionLeases);
    }

    public int hashCode() {
        return Objects.hash(this.retentionLeases);
    }
}

