/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;

public class DocCountProvider {
    private NumericDocValues docCountValues;

    public long getDocCount(int doc) throws IOException {
        if (this.docCountValues != null && this.docCountValues.advanceExact(doc)) {
            return this.docCountValues.longValue();
        }
        return 1L;
    }

    public void setLeafReaderContext(LeafReaderContext ctx) throws IOException {
        this.docCountValues = DocValues.getNumeric((LeafReader)ctx.reader(), (String)"_doc_count");
    }
}

