/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rule.autotagging;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.joda.time.Instant;
import org.opensearch.cluster.metadata.WorkloadGroup;
import org.opensearch.common.ValidationException;
import org.opensearch.rule.autotagging.Attribute;
import org.opensearch.rule.autotagging.FeatureType;

public class RuleValidator {
    private final String id;
    private final String description;
    private final Map<Attribute, Set<String>> attributeMap;
    private final String featureValue;
    private final String updatedAt;
    private final FeatureType featureType;
    public static final int MAX_DESCRIPTION_LENGTH = 256;

    public RuleValidator(String id, String description, Map<Attribute, Set<String>> attributeMap, String featureValue, String updatedAt, FeatureType featureType) {
        this.id = id;
        this.description = description;
        this.attributeMap = attributeMap;
        this.featureValue = featureValue;
        this.updatedAt = updatedAt;
        this.featureType = featureType;
    }

    public void validate() {
        ArrayList<String> errorMessages = new ArrayList<String>();
        errorMessages.addAll(this.validateStringFields());
        errorMessages.addAll(this.validateFeatureType());
        errorMessages.addAll(this.validateUpdatedAtEpoch());
        errorMessages.addAll(this.validateAttributeMap());
        if (!errorMessages.isEmpty()) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationErrors(errorMessages);
            throw new IllegalArgumentException((Throwable)validationException);
        }
    }

    private List<String> validateStringFields() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.isNullOrEmpty(this.id)) {
            errors.add("Rule id can't be null or empty");
        }
        if (this.isNullOrEmpty(this.description)) {
            errors.add("Rule description can't be null or empty");
        } else if (this.description.length() > 256) {
            errors.add("Rule description cannot exceed 256 characters.");
        }
        if (this.isNullOrEmpty(this.featureValue)) {
            errors.add("Rule featureValue can't be null or empty");
        }
        if (this.isNullOrEmpty(this.updatedAt)) {
            errors.add("Rule update time can't be null or empty");
        }
        return errors;
    }

    private boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean isEmpty(String str) {
        return str != null && str.isEmpty();
    }

    private List<String> validateFeatureType() {
        if (this.featureType == null) {
            return List.of("Couldn't identify which feature the rule belongs to. Rule feature can't be null.");
        }
        return new ArrayList<String>();
    }

    private List<String> validateUpdatedAtEpoch() {
        if (this.updatedAt != null && !WorkloadGroup.isValid((long)Instant.parse((String)this.updatedAt).getMillis())) {
            return List.of("Rule update time is not a valid epoch");
        }
        return new ArrayList<String>();
    }

    private List<String> validateAttributeMap() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.attributeMap == null || this.attributeMap.isEmpty()) {
            errors.add("Rule should have at least 1 attribute requirement");
        }
        if (this.attributeMap != null && this.featureType != null) {
            for (Map.Entry<Attribute, Set<String>> entry : this.attributeMap.entrySet()) {
                Attribute attribute = entry.getKey();
                Set<String> attributeValues = entry.getValue();
                errors.addAll(this.validateAttributeExistence(attribute));
                errors.addAll(this.validateMaxAttributeValues(attribute, attributeValues));
                errors.addAll(this.validateAttributeValuesList(attributeValues));
            }
        }
        return errors;
    }

    private List<String> validateAttributeExistence(Attribute attribute) {
        if (!this.featureType.isValidAttribute(attribute)) {
            return List.of(attribute.getName() + " is not a valid attribute within the " + this.featureType.getName() + " feature.");
        }
        return new ArrayList<String>();
    }

    private List<String> validateMaxAttributeValues(Attribute attribute, Set<String> attributeValues) {
        ArrayList<String> errors = new ArrayList<String>();
        String attributeName = attribute.getName();
        if (attributeValues.isEmpty()) {
            errors.add("Attribute values for " + attributeName + " cannot be empty.");
        }
        int maxSize = this.featureType.getMaxNumberOfValuesPerAttribute();
        int actualSize = attributeValues.size();
        if (actualSize > maxSize) {
            errors.add("Each attribute can only have a maximum of " + maxSize + " values. The input attribute " + attributeName + " has length " + attributeValues.size() + ", which exceeds this limit.");
        }
        return errors;
    }

    private List<String> validateAttributeValuesList(Set<String> attributeValues) {
        int maxValueLength = this.featureType.getMaxCharLengthPerAttributeValue();
        ArrayList<String> errors = new ArrayList<String>();
        for (String attributeValue : attributeValues) {
            int asteriskCount;
            if (attributeValue.isEmpty() || attributeValue.length() > maxValueLength) {
                errors.add("Attribute value [" + attributeValue + "] is invalid (empty or exceeds " + maxValueLength + " characters)");
            }
            if ((asteriskCount = (int)attributeValue.chars().filter(c -> c == 42).count()) <= 1 && (asteriskCount != 1 || attributeValue.endsWith("*"))) continue;
            errors.add("Attribute value [" + attributeValue + "] is invalid (only one '*' is allowed and it must appear at the end)");
        }
        return errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuleValidator that = (RuleValidator)o;
        return Objects.equals(this.description, that.description) && Objects.equals(this.attributeMap, that.attributeMap) && Objects.equals(this.featureValue, that.featureValue) && Objects.equals(this.updatedAt, that.updatedAt) && Objects.equals(this.featureType, that.featureType);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.attributeMap, this.featureValue, this.updatedAt, this.featureType);
    }
}

