/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.HitQueue;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TotalHits;

public final class LargeNumHitsTopDocsCollector
implements Collector {
    private final int requestedHitCount;
    private List<ScoreDoc> hits = new ArrayList<ScoreDoc>();
    HitQueue pq;
    ScoreDoc pqTop;
    int totalHits;

    public LargeNumHitsTopDocsCollector(int requestedHitCount) {
        this.requestedHitCount = requestedHitCount;
        this.totalHits = 0;
    }

    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE;
    }

    public LeafCollector getLeafCollector(LeafReaderContext context) {
        final int docBase = context.docBase;
        return new LeafCollector(){
            private Scorable scorer;

            public void setScorer(Scorable scorer) throws IOException {
                this.scorer = scorer;
            }

            public void collect(int doc) throws IOException {
                float score = this.scorer.score();
                assert (score >= 0.0f);
                if (LargeNumHitsTopDocsCollector.this.totalHits < LargeNumHitsTopDocsCollector.this.requestedHitCount) {
                    LargeNumHitsTopDocsCollector.this.hits.add(new ScoreDoc(doc + docBase, score));
                    ++LargeNumHitsTopDocsCollector.this.totalHits;
                    return;
                }
                if (LargeNumHitsTopDocsCollector.this.totalHits == LargeNumHitsTopDocsCollector.this.requestedHitCount) {
                    assert (LargeNumHitsTopDocsCollector.this.pq == null);
                    assert (LargeNumHitsTopDocsCollector.this.pqTop == null);
                    LargeNumHitsTopDocsCollector.this.pq = new HitQueue(LargeNumHitsTopDocsCollector.this.requestedHitCount, false);
                    for (ScoreDoc scoreDoc : LargeNumHitsTopDocsCollector.this.hits) {
                        LargeNumHitsTopDocsCollector.this.pq.add((Object)scoreDoc);
                    }
                    LargeNumHitsTopDocsCollector.this.pqTop = (ScoreDoc)LargeNumHitsTopDocsCollector.this.pq.top();
                    LargeNumHitsTopDocsCollector.this.hits = null;
                }
                if (score > LargeNumHitsTopDocsCollector.this.pqTop.score) {
                    LargeNumHitsTopDocsCollector.this.pqTop.doc = doc + docBase;
                    LargeNumHitsTopDocsCollector.this.pqTop.score = score;
                    LargeNumHitsTopDocsCollector.this.pqTop = (ScoreDoc)LargeNumHitsTopDocsCollector.this.pq.updateTop();
                }
                ++LargeNumHitsTopDocsCollector.this.totalHits;
            }
        };
    }

    public TopDocs topDocs(int howMany) {
        if (howMany <= 0 || howMany > this.totalHits) {
            throw new IllegalArgumentException("Incorrect number of hits requested");
        }
        ScoreDoc[] results = new ScoreDoc[howMany];
        this.populateResults(results, howMany);
        return this.newTopDocs(results);
    }

    protected void populateResults(ScoreDoc[] results, int howMany) {
        if (this.pq != null) {
            assert (this.totalHits > this.requestedHitCount);
            for (int i = howMany - 1; i >= 0; --i) {
                results[i] = (ScoreDoc)this.pq.pop();
            }
            return;
        }
        assert (this.totalHits <= this.requestedHitCount);
        Collections.sort(this.hits, Comparator.comparing(scoreDoc -> Float.valueOf(scoreDoc.score)).reversed().thenComparing(scoreDoc -> scoreDoc.doc));
        for (int i = 0; i < howMany; ++i) {
            results[i] = this.hits.get(i);
        }
    }

    protected TopDocs newTopDocs(ScoreDoc[] results) {
        return results == null ? TopDocsCollector.EMPTY_TOPDOCS : new TopDocs(new TotalHits((long)this.totalHits, TotalHits.Relation.EQUAL_TO), results);
    }

    public TopDocs topDocs() {
        return this.topDocs(Math.min(this.totalHits, this.requestedHitCount));
    }
}

