/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.analysis;

import com.ibm.icu.text.FilteredNormalizer2;
import com.ibm.icu.text.Normalizer2;
import com.ibm.icu.text.UnicodeSet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.icu.ICUNormalizer2Filter;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.Environment;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.AbstractTokenFilterFactory;
import org.opensearch.index.analysis.NormalizingTokenFilterFactory;

public class IcuNormalizerTokenFilterFactory
extends AbstractTokenFilterFactory
implements NormalizingTokenFilterFactory {
    private final Normalizer2 normalizer;

    public IcuNormalizerTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        String method = settings.get("name", "nfkc_cf");
        Normalizer2 normalizer = Normalizer2.getInstance(null, (String)method, (Normalizer2.Mode)Normalizer2.Mode.COMPOSE);
        this.normalizer = IcuNormalizerTokenFilterFactory.wrapWithUnicodeSetFilter(indexSettings, normalizer, settings);
    }

    public TokenStream create(TokenStream tokenStream) {
        return new ICUNormalizer2Filter(tokenStream, this.normalizer);
    }

    static Normalizer2 wrapWithUnicodeSetFilter(IndexSettings indexSettings, Normalizer2 normalizer, Settings settings) {
        String unicodeSetFilter = settings.get("unicode_set_filter");
        if (unicodeSetFilter != null) {
            UnicodeSet unicodeSet = new UnicodeSet(unicodeSetFilter);
            unicodeSet.freeze();
            return new FilteredNormalizer2(normalizer, unicodeSet);
        }
        return normalizer;
    }
}

