/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.connector.Request;
import org.apache.coyote.ActionCode;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.SSLHostConfig;

public class SSLAuthenticator
extends AuthenticatorBase {
    private final Log log = LogFactory.getLog(SSLAuthenticator.class);

    @Override
    protected boolean doAuthenticate(Request request, HttpServletResponse httpServletResponse) throws IOException {
        X509Certificate[] x509CertificateArray;
        if (this.checkForCachedAuthentication(request, httpServletResponse, false)) {
            return true;
        }
        if (this.containerLog.isTraceEnabled()) {
            this.containerLog.trace((Object)" Looking up certificates");
        }
        if ((x509CertificateArray = this.getRequestCertificates(request)) == null || x509CertificateArray.length < 1) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)sm.getString("sslAuthenticatorValve.noCertificates"));
            }
            httpServletResponse.sendError(401, sm.getString("authenticator.certificates"));
            return false;
        }
        Principal principal = this.context.getRealm().authenticate(x509CertificateArray);
        if (principal == null) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)sm.getString("sslAuthenticatorValve.authFailed"));
            }
            httpServletResponse.sendError(401, sm.getString("authenticator.unauthorized"));
            return false;
        }
        this.register(request, httpServletResponse, principal, "CLIENT_CERT", null, null);
        return true;
    }

    @Override
    protected String getAuthMethod() {
        return "CLIENT_CERT";
    }

    @Override
    protected boolean isPreemptiveAuthPossible(Request request) {
        X509Certificate[] x509CertificateArray = this.getRequestCertificates(request);
        return x509CertificateArray != null && x509CertificateArray.length > 0;
    }

    protected X509Certificate[] getRequestCertificates(Request request) throws IllegalStateException {
        X509Certificate[] x509CertificateArray = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        if (x509CertificateArray == null || x509CertificateArray.length < 1) {
            try {
                request.getCoyoteRequest().action(ActionCode.REQ_SSL_CERTIFICATE, null);
                x509CertificateArray = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return x509CertificateArray;
    }

    @Override
    protected void startInternal() throws LifecycleException {
        Connector[] connectorArray;
        super.startInternal();
        Container container = this.getContainer();
        if (!(container instanceof Context)) {
            return;
        }
        Context context = (Context)container;
        if (!((container = context.getParent()) instanceof Host)) {
            return;
        }
        Host host = (Host)container;
        if (!((container = host.getParent()) instanceof Engine)) {
            return;
        }
        Engine engine = (Engine)container;
        for (Connector connector : connectorArray = engine.getService().findConnectors()) {
            int n;
            boolean bl = true;
            SSLHostConfig[] sSLHostConfigArray = connector.findSslHostConfigs();
            int n2 = sSLHostConfigArray.length;
            for (n = 0; n < n2; ++n) {
                SSLHostConfig sSLHostConfig = sSLHostConfigArray[n];
                if (sSLHostConfig.getCertificateVerification() == SSLHostConfig.CertificateVerification.REQUIRED) continue;
                bl = false;
                break;
            }
            if (bl) continue;
            for (SSLHostConfig sSLHostConfig : sSLHostConfigArray = connector.findUpgradeProtocols()) {
                if (!"h2".equals(sSLHostConfig.getAlpnName())) continue;
                this.log.warn((Object)sm.getString("sslAuthenticatorValve.http2", new Object[]{context.getName(), host.getName(), connector}));
                break;
            }
            SSLHostConfig[] sSLHostConfigArray2 = connector.findSslHostConfigs();
            n = sSLHostConfigArray2.length;
            for (int i = 0; i < n; ++i) {
                SSLHostConfig sSLHostConfig;
                sSLHostConfig = sSLHostConfigArray2[i];
                if (sSLHostConfig.isTls13RenegotiationAvailable()) continue;
                String[] stringArray = sSLHostConfig.getEnabledProtocols();
                if (stringArray == null) {
                    stringArray = sSLHostConfig.getProtocols().toArray(new String[0]);
                }
                for (String string : stringArray) {
                    if (!"TLSv1.3".equals(string)) continue;
                    this.log.warn((Object)sm.getString("sslAuthenticatorValve.tls13", new Object[]{context.getName(), host.getName(), connector}));
                }
            }
        }
    }
}

