/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.fileupload.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.tomcat.util.http.fileupload.FileItem;
import org.apache.tomcat.util.http.fileupload.FileItemHeaders;
import org.apache.tomcat.util.http.fileupload.FileItemIterator;
import org.apache.tomcat.util.http.fileupload.FileItemStream;
import org.apache.tomcat.util.http.fileupload.FileUploadBase;
import org.apache.tomcat.util.http.fileupload.FileUploadException;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.apache.tomcat.util.http.fileupload.MultipartStream;
import org.apache.tomcat.util.http.fileupload.RequestContext;
import org.apache.tomcat.util.http.fileupload.UploadContext;
import org.apache.tomcat.util.http.fileupload.impl.FileItemStreamImpl;
import org.apache.tomcat.util.http.fileupload.impl.FileUploadIOException;
import org.apache.tomcat.util.http.fileupload.impl.InvalidContentTypeException;
import org.apache.tomcat.util.http.fileupload.impl.SizeLimitExceededException;
import org.apache.tomcat.util.http.fileupload.util.LimitedInputStream;

public class FileItemIteratorImpl
implements FileItemIterator {
    private final FileUploadBase fileUploadBase;
    private final RequestContext ctx;
    private long sizeMax;
    private long fileSizeMax;
    private MultipartStream multiPartStream;
    private MultipartStream.ProgressNotifier progressNotifier;
    private byte[] multiPartBoundary;
    private FileItemStreamImpl currentItem;
    private String currentFieldName;
    private boolean skipPreamble;
    private boolean itemValid;
    private boolean eof;

    @Override
    public long getSizeMax() {
        return this.sizeMax;
    }

    @Override
    public void setSizeMax(long l) {
        this.sizeMax = l;
    }

    @Override
    public long getFileSizeMax() {
        return this.fileSizeMax;
    }

    @Override
    public void setFileSizeMax(long l) {
        this.fileSizeMax = l;
    }

    public FileItemIteratorImpl(FileUploadBase fileUploadBase, RequestContext requestContext) throws FileUploadException, IOException {
        this.fileUploadBase = fileUploadBase;
        this.sizeMax = fileUploadBase.getSizeMax();
        this.fileSizeMax = fileUploadBase.getFileSizeMax();
        this.ctx = Objects.requireNonNull(requestContext, "requestContext");
        this.skipPreamble = true;
        this.findNextItem();
    }

    protected void init(FileUploadBase fileUploadBase, RequestContext requestContext) throws FileUploadException, IOException {
        InputStream inputStream;
        String string = this.ctx.getContentType();
        if (null == string || !string.toLowerCase(Locale.ENGLISH).startsWith("multipart/")) {
            throw new InvalidContentTypeException(String.format("the request doesn't contain a %s or %s stream, content type header is %s", "multipart/form-data", "multipart/mixed", string));
        }
        long l = ((UploadContext)this.ctx).contentLength();
        if (this.sizeMax >= 0L) {
            if (l != -1L && l > this.sizeMax) {
                throw new SizeLimitExceededException(String.format("the request was rejected because its size (%s) exceeds the configured maximum (%s)", l, this.sizeMax), l, this.sizeMax);
            }
            inputStream = new LimitedInputStream(this.ctx.getInputStream(), this.sizeMax){

                @Override
                protected void raiseError(long l, long l2) throws IOException {
                    SizeLimitExceededException sizeLimitExceededException = new SizeLimitExceededException(String.format("the request was rejected because its size (%s) exceeds the configured maximum (%s)", l2, l), l2, l);
                    throw new FileUploadIOException(sizeLimitExceededException);
                }
            };
        } else {
            inputStream = this.ctx.getInputStream();
        }
        String string2 = fileUploadBase.getHeaderEncoding();
        if (string2 == null) {
            string2 = this.ctx.getCharacterEncoding();
        }
        this.multiPartBoundary = fileUploadBase.getBoundary(string);
        if (this.multiPartBoundary == null) {
            IOUtils.closeQuietly(inputStream);
            throw new FileUploadException("the request was rejected because no multipart boundary was found");
        }
        this.progressNotifier = new MultipartStream.ProgressNotifier(fileUploadBase.getProgressListener(), l);
        try {
            this.multiPartStream = new MultipartStream(inputStream, this.multiPartBoundary, this.progressNotifier);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            IOUtils.closeQuietly(inputStream);
            throw new InvalidContentTypeException(String.format("The boundary specified in the %s header is too long", "Content-type"), illegalArgumentException);
        }
        this.multiPartStream.setHeaderEncoding(string2);
        this.multiPartStream.setPartHeaderSizeMax(fileUploadBase.getPartHeaderSizeMax());
    }

    public MultipartStream getMultiPartStream() throws FileUploadException, IOException {
        if (this.multiPartStream == null) {
            this.init(this.fileUploadBase, this.ctx);
        }
        return this.multiPartStream;
    }

    private boolean findNextItem() throws FileUploadException, IOException {
        if (this.eof) {
            return false;
        }
        if (this.currentItem != null) {
            this.currentItem.close();
            this.currentItem = null;
        }
        MultipartStream multipartStream = this.getMultiPartStream();
        while (true) {
            String string;
            boolean bl;
            if (!(bl = this.skipPreamble ? multipartStream.skipPreamble() : multipartStream.readBoundary())) {
                if (this.currentFieldName == null) {
                    this.eof = true;
                    return false;
                }
                multipartStream.setBoundary(this.multiPartBoundary);
                this.currentFieldName = null;
                continue;
            }
            FileItemHeaders fileItemHeaders = this.fileUploadBase.getParsedHeaders(multipartStream.readHeaders());
            if (this.currentFieldName == null) {
                string = this.fileUploadBase.getFieldName(fileItemHeaders);
                if (string != null) {
                    Object object;
                    String string2 = fileItemHeaders.getHeader("Content-type");
                    if (string2 != null && string2.toLowerCase(Locale.ENGLISH).startsWith("multipart/mixed")) {
                        this.currentFieldName = string;
                        object = this.fileUploadBase.getBoundary(string2);
                        multipartStream.setBoundary((byte[])object);
                        this.skipPreamble = true;
                        continue;
                    }
                    object = this.fileUploadBase.getFileName(fileItemHeaders);
                    this.currentItem = new FileItemStreamImpl(this, (String)object, string, fileItemHeaders.getHeader("Content-type"), object == null, this.getContentLength(fileItemHeaders));
                    this.currentItem.setHeaders(fileItemHeaders);
                    this.progressNotifier.noteItem();
                    this.itemValid = true;
                    return true;
                }
            } else {
                string = this.fileUploadBase.getFileName(fileItemHeaders);
                if (string != null) {
                    this.currentItem = new FileItemStreamImpl(this, string, this.currentFieldName, fileItemHeaders.getHeader("Content-type"), false, this.getContentLength(fileItemHeaders));
                    this.currentItem.setHeaders(fileItemHeaders);
                    this.progressNotifier.noteItem();
                    this.itemValid = true;
                    return true;
                }
            }
            multipartStream.discardBodyData();
        }
    }

    private long getContentLength(FileItemHeaders fileItemHeaders) {
        try {
            return Long.parseLong(fileItemHeaders.getHeader("Content-length"));
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    @Override
    public boolean hasNext() throws FileUploadException, IOException {
        if (this.eof) {
            return false;
        }
        if (this.itemValid) {
            return true;
        }
        try {
            return this.findNextItem();
        }
        catch (FileUploadIOException fileUploadIOException) {
            throw (FileUploadException)fileUploadIOException.getCause();
        }
    }

    @Override
    public FileItemStream next() throws FileUploadException, IOException {
        if (this.eof || !this.itemValid && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.itemValid = false;
        return this.currentItem;
    }

    @Override
    public List<FileItem> getFileItems() throws FileUploadException, IOException {
        ArrayList<FileItem> arrayList = new ArrayList<FileItem>();
        while (this.hasNext()) {
            FileItemStream fileItemStream = this.next();
            FileItem fileItem = this.fileUploadBase.getFileItemFactory().createItem(fileItemStream.getFieldName(), fileItemStream.getContentType(), fileItemStream.isFormField(), fileItemStream.getName());
            arrayList.add(fileItem);
        }
        return arrayList;
    }
}

