/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.threaddump.impl;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.ApplicationFinder;
import org.graalvm.visualvm.threaddump.ThreadDumpSupport;
import org.netbeans.api.sendopts.CommandException;
import org.netbeans.spi.sendopts.Env;
import org.netbeans.spi.sendopts.Option;
import org.netbeans.spi.sendopts.OptionProcessor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public final class ThreadDumpArgument
extends OptionProcessor {
    private static final String LONG_NAME = "threaddump";
    private static final Option ARGUMENT = Option.shortDescription((Option)Option.requiredArgument((char)'\uffff', (String)"threaddump"), (String)"org.graalvm.visualvm.threaddump.impl.Bundle", (String)"Argument_ShortDescr");

    protected Set<Option> getOptions() {
        return Collections.singleton(ARGUMENT);
    }

    protected void process(Env env, Map<Option, String[]> maps) throws CommandException {
        String[] pids = maps.get(ARGUMENT);
        if (pids != null && pids.length == 1) {
            try {
                int pid = Integer.valueOf(pids[0]);
                new ApplicationFinder(pid){

                    public void found(Application application) {
                        ThreadDumpSupport.getInstance().takeThreadDump(application, true);
                    }

                    public void notFound(int pid, String id) {
                        NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ThreadDumpArgument.class, (String)"MSG_NO_APP_PID", (Object[])new Object[]{Integer.toString(pid)}), 2);
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)desc);
                    }
                }.find();
            }
            catch (NumberFormatException e) {
                throw new CommandException(0, "Incorrect pid format for --threaddump: " + e.getMessage());
            }
        } else {
            throw new CommandException(0, "--threaddump requires exactly one value");
        }
    }
}

