/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.core.startup.layers.BinaryFS;
import org.netbeans.core.startup.layers.LayerCacheManager;
import org.netbeans.core.startup.layers.ParsingLayerCacheManager;
import org.netbeans.core.startup.preferences.RelPaths;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;

final class BinaryCacheManager
extends ParsingLayerCacheManager {
    private final String cacheLocation;
    private static final String[] ATTR_TYPES = new String[]{"bytevalue", "shortvalue", "intvalue", "longvalue", "floatvalue", "doublevalue", "boolvalue", "charvalue", "stringvalue", "urlvalue", "methodvalue", "newvalue", "serialvalue", "bundlevalue"};
    private HashMap<ParsingLayerCacheManager.MemFileOrFolder, Integer> sizes;

    BinaryCacheManager() {
        this("all-layers.dat");
    }

    BinaryCacheManager(String string) {
        this.cacheLocation = string;
    }

    @Override
    public FileSystem createEmptyFileSystem() throws IOException {
        return FileUtil.createMemoryFileSystem();
    }

    @Override
    public FileSystem load(FileSystem fileSystem, ByteBuffer byteBuffer) throws IOException {
        try {
            BinaryFS binaryFS = new BinaryFS(this.cacheLocation(), byteBuffer);
            return binaryFS;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new IOException(bufferUnderflowException);
        }
    }

    @Override
    public String cacheLocation() {
        return this.cacheLocation;
    }

    @Override
    protected boolean openURLs() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void store(FileSystem fileSystem, ParsingLayerCacheManager.MemFolder memFolder, OutputStream outputStream) throws IOException {
        try {
            this.sizes = new HashMap(1000);
            HashMap<String, int[]> hashMap = new HashMap<String, int[]>();
            int n = this.computeSize(memFolder, hashMap);
            LayerCacheManager.err.log(Level.FINE, "Writing binary layer cache of length {0} to {1}", new Object[]{n + BinaryFS.MAGIC.length, this.cacheLocation()});
            outputStream.write(BinaryFS.MAGIC);
            BinaryWriter binaryWriter = new BinaryWriter(outputStream, memFolder, n, hashMap);
            this.writeFolder(binaryWriter, memFolder, true);
        }
        finally {
            this.sizes = null;
            outputStream.close();
        }
    }

    void writeFolder(BinaryWriter binaryWriter, ParsingLayerCacheManager.MemFolder memFolder) throws IOException {
        this.writeFolder(binaryWriter, memFolder, false);
    }

    void writeFolder(BinaryWriter binaryWriter, ParsingLayerCacheManager.MemFolder memFolder, boolean bl) throws IOException {
        this.writeBaseURLs(memFolder, binaryWriter, bl);
        if (memFolder.attrs != null) {
            binaryWriter.writeInt(memFolder.attrs.size());
            for (Iterator<ParsingLayerCacheManager.MemFileOrFolder> iterator : memFolder.attrs) {
                this.writeAttribute(binaryWriter, (ParsingLayerCacheManager.MemAttr)((Object)iterator));
            }
        } else {
            binaryWriter.writeInt(0);
        }
        if (memFolder.children != null) {
            binaryWriter.writeInt(memFolder.children.size());
            int n = binaryWriter.getPosition();
            for (ParsingLayerCacheManager.MemFileOrFolder memFileOrFolder : memFolder.children) {
                n += this.computeHeaderSize(memFileOrFolder, null);
            }
            for (ParsingLayerCacheManager.MemFileOrFolder memFileOrFolder : memFolder.children) {
                binaryWriter.writeString(memFileOrFolder.name);
                binaryWriter.writeByte(memFileOrFolder instanceof ParsingLayerCacheManager.MemFile ? (byte)0 : 1);
                binaryWriter.writeInt(n);
                n += this.computeSize(memFileOrFolder, null);
            }
            for (ParsingLayerCacheManager.MemFileOrFolder memFileOrFolder : memFolder.children) {
                if (memFileOrFolder instanceof ParsingLayerCacheManager.MemFile) {
                    this.writeFile(binaryWriter, (ParsingLayerCacheManager.MemFile)memFileOrFolder);
                    continue;
                }
                this.writeFolder(binaryWriter, (ParsingLayerCacheManager.MemFolder)memFileOrFolder);
            }
        } else {
            binaryWriter.writeInt(0);
        }
    }

    private void writeBaseURLs(ParsingLayerCacheManager.MemFileOrFolder memFileOrFolder, BinaryWriter binaryWriter, boolean bl) throws IOException {
        List<URL> list = memFileOrFolder.getURLs();
        if (list.size() > 0) {
            int n = list.size() - 1;
            for (int i = 0; i < n; ++i) {
                URL uRL = list.get(i);
                binaryWriter.writeBaseURL(uRL);
            }
            binaryWriter.writeBaseURL(list.get(n), true);
        } else assert (bl);
    }

    private void writeFile(BinaryWriter binaryWriter, ParsingLayerCacheManager.MemFile memFile) throws IOException {
        this.writeBaseURLs(memFile, binaryWriter, false);
        if (memFile.attrs != null) {
            binaryWriter.writeInt(memFile.attrs.size());
            for (ParsingLayerCacheManager.MemAttr memAttr : memFile.attrs) {
                this.writeAttribute(binaryWriter, memAttr);
            }
        } else {
            binaryWriter.writeInt(0);
        }
        if (memFile.ref != null) {
            binaryWriter.writeInt(-1);
            binaryWriter.writeString(BinaryCacheManager.toRelativeURL(memFile.ref));
        } else if (memFile.contents != null) {
            binaryWriter.writeInt(memFile.contents.length);
            binaryWriter.writeBytes(memFile.contents);
        } else {
            binaryWriter.writeInt(0);
        }
    }

    private void writeAttribute(BinaryWriter binaryWriter, ParsingLayerCacheManager.MemAttr memAttr) throws IOException {
        binaryWriter.writeString(memAttr.name);
        for (int i = 0; i < ATTR_TYPES.length; ++i) {
            if (!ATTR_TYPES[i].equals(memAttr.type)) continue;
            binaryWriter.writeByte((byte)i);
            if (i == 9) {
                binaryWriter.writeString(BinaryCacheManager.toRelativeURL(memAttr.data));
            } else {
                binaryWriter.writeString(memAttr.data);
            }
            return;
        }
        throw new IOException("Wrong type: " + memAttr);
    }

    private int computeSize(ParsingLayerCacheManager.MemFileOrFolder memFileOrFolder, Map<String, int[]> map) {
        int n;
        block7: {
            Object object;
            block5: {
                block6: {
                    Integer n2 = this.sizes.get(memFileOrFolder);
                    if (n2 != null) {
                        return n2;
                    }
                    n = memFileOrFolder.getURLs().size() * 4;
                    n += 4;
                    if (memFileOrFolder.attrs != null) {
                        for (ParsingLayerCacheManager.MemAttr object2 : memFileOrFolder.attrs) {
                            n += this.computeSize(object2, map);
                        }
                    }
                    if (!(memFileOrFolder instanceof ParsingLayerCacheManager.MemFile)) break block5;
                    object = (ParsingLayerCacheManager.MemFile)memFileOrFolder;
                    n += 4;
                    if (((ParsingLayerCacheManager.MemFile)object).ref == null) break block6;
                    n += BinaryCacheManager.computeSize(BinaryCacheManager.toRelativeURL(((ParsingLayerCacheManager.MemFile)object).ref), map);
                    break block7;
                }
                if (((ParsingLayerCacheManager.MemFile)object).contents == null) break block7;
                n += ((ParsingLayerCacheManager.MemFile)object).contents.length;
                break block7;
            }
            object = (ParsingLayerCacheManager.MemFolder)memFileOrFolder;
            n += 4;
            if (((ParsingLayerCacheManager.MemFolder)object).children != null) {
                for (ParsingLayerCacheManager.MemFileOrFolder memFileOrFolder2 : ((ParsingLayerCacheManager.MemFolder)object).children) {
                    n += this.computeHeaderSize(memFileOrFolder2, map);
                    n += this.computeSize(memFileOrFolder2, map);
                }
            }
        }
        this.sizes.put(memFileOrFolder, n);
        return n;
    }

    private int computeHeaderSize(ParsingLayerCacheManager.MemFileOrFolder memFileOrFolder, Map<String, int[]> map) {
        return BinaryCacheManager.computeSize(memFileOrFolder.name, map) + 1 + 4;
    }

    private static int computeSize(String string, Map<String, int[]> map) {
        if (map != null) {
            int[] nArray = map.get(string);
            if (nArray == null) {
                nArray = new int[1];
                map.put(string, nArray);
            }
            nArray[0] = nArray[0] + 1;
        }
        return 4;
    }

    private int computeSize(ParsingLayerCacheManager.MemAttr memAttr, Map<String, int[]> map) {
        return BinaryCacheManager.computeSize(memAttr.name, map) + 1 + BinaryCacheManager.computeSize(memAttr.data, map);
    }

    private static String toRelativeURL(URL uRL) {
        return BinaryCacheManager.toRelativeURL(uRL.toExternalForm());
    }

    private static String toRelativeURL(String string) {
        String[] stringArray;
        if (string.startsWith("jar:file:") && (stringArray = RelPaths.findRelativePath(string.substring(9))) != null) {
            string = stringArray[0] + '@' + stringArray[1];
        }
        return string;
    }

    private static final class BinaryWriter {
        private OutputStream os;
        private int position;
        private final Map<String, Object> urls;
        private final Map<String, Integer> strings;

        BinaryWriter(OutputStream outputStream, ParsingLayerCacheManager.MemFolder memFolder, int n, Map<String, int[]> map) throws IOException {
            this.os = outputStream;
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            this.strings = Collections.unmodifiableMap(hashMap);
            this.urls = this.writeBaseUrls(memFolder, n, map, hashMap);
            this.position = 0;
        }

        int getPosition() {
            return this.position;
        }

        void writeByte(byte by) throws IOException {
            this.os.write(by);
            ++this.position;
        }

        void writeBytes(byte[] byArray) throws IOException {
            this.os.write(byArray);
            this.position += byArray.length;
        }

        void writeInt(int n) throws IOException {
            byte[] byArray = new byte[]{(byte)n, (byte)(n >> 8), (byte)(n >> 16), (byte)(n >> 24)};
            this.writeBytes(byArray);
        }

        void writeString(String string) throws IOException {
            Integer n = this.strings.get(string);
            assert (n != null) : "Found " + string;
            this.writeInt(n);
        }

        void writeBaseURL(URL uRL) throws IOException {
            this.writeBaseURL(uRL, false);
        }

        void writeBaseURL(URL uRL, boolean bl) throws IOException {
            String string = BinaryCacheManager.toRelativeURL(uRL);
            int[] nArray = (int[])this.urls.get(string);
            assert (nArray != null) : "Should not be null, because it was collected: " + uRL + " map: " + this.urls;
            int n = nArray[0];
            if (bl) {
                n = -10 - n;
            }
            this.writeInt(n);
        }

        private Map<String, Object> writeBaseUrls(ParsingLayerCacheManager.MemFileOrFolder memFileOrFolder, int n, Map<String, int[]> map, Map<String, Integer> map2) throws IOException {
            Object object;
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
            int[] nArray = new int[1];
            this.collectBaseUrls(memFileOrFolder, linkedHashMap, nArray);
            int n2 = 0;
            Iterator<Map.Entry<String, Object>> iterator = linkedHashMap.entrySet().iterator();
            for (int i = 0; i < nArray[0]; ++i) {
                object = iterator.next();
                String string = object.getKey();
                assert (((int[])object.getValue())[0] == i) : i + "th key should be it " + ((int[])object.getValue())[0];
                n2 += BinaryCacheManager.computeSize(string, map);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            object = new DataOutputStream(byteArrayOutputStream);
            for (String string : this.sort(map.entrySet())) {
                map2.put(string, ((DataOutputStream)object).size());
                ((DataOutputStream)object).writeUTF(string);
            }
            ((DataOutputStream)object).flush();
            int n3 = ((DataOutputStream)object).size();
            this.writeInt(BinaryFS.MAGIC.length + 4 + 4 + n3 + 4 + n2 + n);
            this.writeInt(n3);
            this.os.write(byteArrayOutputStream.toByteArray());
            this.writeInt(n2);
            iterator = linkedHashMap.entrySet().iterator();
            for (int i = 0; i < nArray[0]; ++i) {
                Map.Entry<String, Object> entry = iterator.next();
                this.writeString(entry.getKey());
            }
            return linkedHashMap;
        }

        private void collectBaseUrls(ParsingLayerCacheManager.MemFileOrFolder memFileOrFolder, Map<String, Object> map, int[] nArray) {
            for (URL object : memFileOrFolder.getURLs()) {
                String string = BinaryCacheManager.toRelativeURL(object);
                int[] nArray2 = (int[])map.get(string);
                if (nArray2 != null) continue;
                map.put(string, nArray.clone());
                nArray[0] = nArray[0] + 1;
            }
            if (memFileOrFolder instanceof ParsingLayerCacheManager.MemFolder && ((ParsingLayerCacheManager.MemFolder)memFileOrFolder).children != null) {
                for (ParsingLayerCacheManager.MemFileOrFolder memFileOrFolder2 : ((ParsingLayerCacheManager.MemFolder)memFileOrFolder).children) {
                    this.collectBaseUrls(memFileOrFolder2, map, nArray);
                }
            }
        }

        private List<String> sort(Set<Map.Entry<String, int[]>> set) {
            ArrayList<Map.Entry<String, int[]>> arrayList = new ArrayList<Map.Entry<String, int[]>>(set);
            class C
            implements Comparator<Map.Entry<String, int[]>> {
                C() {
                }

                @Override
                public int compare(Map.Entry<String, int[]> entry, Map.Entry<String, int[]> entry2) {
                    return entry2.getValue()[0] - entry.getValue()[0];
                }
            }
            arrayList.sort(new C());
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (Map.Entry entry : arrayList) {
                arrayList2.add((String)entry.getKey());
            }
            return arrayList2;
        }
    }
}

