/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components.calendar;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.ref.WeakReference;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicButtonUI;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.components.calendar.JMonthChooser;
import org.freeplane.core.ui.components.calendar.JYearChooser;

public class JDayChooser
extends JPanel
implements ActionListener,
KeyListener {
    public static final String DAY_PROPERTY = "day";
    private static final long serialVersionUID = 1L;
    private boolean alwaysFireDayProperty;
    protected Calendar calendar;
    protected int day;
    protected boolean dayBordersVisible;
    protected String[] dayNames;
    protected JPanel dayPanel;
    protected JButton[] days;
    private JButton todayButton;
    protected Color decorationBackgroundColor;
    protected boolean decorationBackgroundVisible = true;
    protected boolean decorationBordersVisible;
    protected Date defaultMaxSelectableDate;
    protected Date defaultMinSelectableDate;
    protected boolean initialized;
    protected Locale locale;
    protected int maxDayCharacters;
    protected Date maxSelectableDate;
    protected Date minSelectableDate;
    protected JMonthChooser monthChooser = null;
    protected Color defaultButtonBackgroundColor;
    protected Color selectedColor;
    protected JButton selectedDay;
    protected Color sundayForeground;
    protected Color todayBackground;
    protected Calendar today;
    private Timer todayUpdateTimer;
    protected Color weekdayForeground;
    protected boolean weekOfYearVisible;
    protected JPanel weekPanel;
    protected JButton[] weeks;
    protected JYearChooser yearChooser = null;

    public static void main(String[] s) {
        JFrame frame = new JFrame("JDayChooser");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(new JDayChooser());
        frame.pack();
        frame.setVisible(true);
    }

    public JDayChooser() {
        this(false);
    }

    public JDayChooser(boolean weekOfYearVisible) {
        this.setName("JDayChooser");
        this.setBackground(Color.blue);
        this.weekOfYearVisible = weekOfYearVisible;
        this.locale = Locale.getDefault();
        this.days = new JButton[49];
        this.selectedDay = null;
        this.calendar = Calendar.getInstance(this.locale);
        this.setLayout(new BorderLayout());
        this.dayPanel = new JPanel();
        this.dayPanel.setLayout(new GridLayout(7, 7));
        this.todayBackground = new Color(232, 232, 128);
        this.sundayForeground = new Color(164, 0, 0);
        this.weekdayForeground = new Color(0, 90, 164);
        this.decorationBackgroundColor = new Color(210, 228, 238);
        this.addKeyListener(this);
        for (int y = 0; y < 7; ++y) {
            for (int x = 0; x < 7; ++x) {
                int index = x + 7 * y;
                if (y == 0) {
                    this.days[index] = new DecoratorButton();
                } else {
                    this.days[index] = new JDayButton(){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public void paint(Graphics g) {
                            if ("Windows".equals(UIManager.getLookAndFeel().getID()) && JDayChooser.this.selectedDay == this) {
                                g.setColor(JDayChooser.this.selectedColor);
                                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                            }
                            super.paint(g);
                        }
                    };
                    this.days[index].addActionListener(this);
                }
                this.days[index].setMargin(new Insets(0, 0, 0, 0));
                this.days[index].setFocusable(false);
                this.dayPanel.add(this.days[index]);
            }
        }
        this.weekPanel = new JPanel();
        this.weekPanel.setLayout(new GridLayout(7, 1));
        this.weeks = new JButton[7];
        for (int i = 0; i < 7; ++i) {
            this.weeks[i] = new DecoratorButton();
            this.weeks[i].setMargin(new Insets(0, 0, 0, 0));
            this.weeks[i].setFocusPainted(false);
            this.weeks[i].setForeground(new Color(100, 100, 100));
            if (i != 0) {
                this.weeks[i].setText("0" + (i + 1));
            }
            this.weekPanel.add(this.weeks[i]);
        }
        Calendar tmpCalendar = Calendar.getInstance();
        tmpCalendar.set(1, 0, 1, 1, 1);
        this.minSelectableDate = this.defaultMinSelectableDate = tmpCalendar.getTime();
        tmpCalendar.set(9999, 0, 1, 1, 1);
        this.maxSelectableDate = this.defaultMaxSelectableDate = tmpCalendar.getTime();
        this.init();
        this.setDay(Calendar.getInstance().get(5));
        this.add((Component)this.dayPanel, "Center");
        if (weekOfYearVisible) {
            this.add((Component)this.weekPanel, "West");
        }
        this.initialized = true;
        this.updateUI();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.requestFocusInWindow();
        JButton button = (JButton)e.getSource();
        String buttonText = button.getText();
        int day = new Integer(buttonText);
        this.setDay(day);
    }

    private void updateDayNames() {
        int firstDayOfWeek = this.calendar.getFirstDayOfWeek();
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.locale);
        this.dayNames = dateFormatSymbols.getShortWeekdays();
        int day = firstDayOfWeek;
        for (int i = 0; i < 7; ++i) {
            if (this.maxDayCharacters > 0 && this.maxDayCharacters < 5 && this.dayNames[day].length() >= this.maxDayCharacters) {
                this.dayNames[day] = this.dayNames[day].substring(0, this.maxDayCharacters);
            }
            this.days[i].setText(this.dayNames[day]);
            if (day == 1) {
                this.days[i].setForeground(this.sundayForeground);
            } else {
                this.days[i].setForeground(this.weekdayForeground);
            }
            if (day < 7) {
                ++day;
                continue;
            }
            day -= 6;
        }
    }

    protected void updateDays() {
        int i;
        Calendar dateCalendar = (Calendar)this.calendar.clone();
        dateCalendar.set(11, 0);
        dateCalendar.set(12, 0);
        dateCalendar.set(13, 0);
        dateCalendar.set(14, 0);
        Calendar minCal = Calendar.getInstance();
        minCal.setTime(this.minSelectableDate);
        minCal.set(11, 0);
        minCal.set(12, 0);
        minCal.set(13, 0);
        minCal.set(14, 0);
        Calendar maxCal = Calendar.getInstance();
        maxCal.setTime(this.maxSelectableDate);
        maxCal.set(11, 0);
        maxCal.set(12, 0);
        maxCal.set(13, 0);
        maxCal.set(14, 0);
        int firstDayOfWeek = dateCalendar.getFirstDayOfWeek();
        dateCalendar.set(5, 1);
        int firstDay = dateCalendar.get(7) - firstDayOfWeek;
        if (firstDay < 0) {
            firstDay += 7;
        }
        for (i = 0; i < firstDay; ++i) {
            this.days[i + 7].setVisible(false);
            this.days[i + 7].setText("");
        }
        dateCalendar.add(2, 1);
        Date firstDayInNextMonth = dateCalendar.getTime();
        dateCalendar.add(2, -1);
        Date day = dateCalendar.getTime();
        int n = 0;
        this.todayButton = null;
        Color foregroundColor = this.getForeground();
        while (day.before(firstDayInNextMonth)) {
            int paintedButtonIndex = i + n + 7;
            JButton dayButton = this.days[paintedButtonIndex];
            dayButton.setText(Integer.toString(n + 1));
            dayButton.setVisible(true);
            boolean paintsToday = this.isToday(dateCalendar);
            if (paintsToday) {
                this.todayButton = dayButton;
                dayButton.setForeground(this.sundayForeground);
            } else {
                dayButton.setForeground(foregroundColor);
            }
            if (n + 1 == this.day) {
                dayButton.setBackground(this.selectedColor);
                this.selectedDay = dayButton;
            } else if (paintsToday) {
                dayButton.setBackground(this.todayBackground);
            } else {
                dayButton.setBackground(this.defaultButtonBackgroundColor);
            }
            if (dateCalendar.before(minCal) || dateCalendar.after(maxCal)) {
                dayButton.setEnabled(false);
            } else {
                dayButton.setEnabled(true);
            }
            ++n;
            dateCalendar.add(5, 1);
            day = dateCalendar.getTime();
        }
        for (int invisibleButtonIndex = n + i + 7; invisibleButtonIndex < 49; ++invisibleButtonIndex) {
            this.days[invisibleButtonIndex].setVisible(false);
            this.days[invisibleButtonIndex].setText("");
        }
        this.drawWeeks();
    }

    private boolean isToday(Calendar dateCalendar) {
        return dateCalendar.get(6) == this.today.get(6) && dateCalendar.get(1) == this.today.get(1);
    }

    protected void drawWeeks() {
        Calendar tmpCalendar = (Calendar)this.calendar.clone();
        for (int i = 1; i < 7; ++i) {
            tmpCalendar.set(5, i * 7 - 6);
            int week = tmpCalendar.get(3);
            String buttonText = Integer.toString(week);
            if (week < 10) {
                buttonText = "0" + buttonText;
            }
            this.weeks[i].setText(buttonText);
            if (i != 5 && i != 6) continue;
            this.weeks[i].setVisible(this.days[i * 7].isVisible());
        }
    }

    public int getDay() {
        return this.day;
    }

    public JPanel getDayPanel() {
        return this.dayPanel;
    }

    public Color getDecorationBackgroundColor() {
        return this.decorationBackgroundColor;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public int getMaxDayCharacters() {
        return this.maxDayCharacters;
    }

    public Date getMaxSelectableDate() {
        return this.maxSelectableDate;
    }

    public Date getMinSelectableDate() {
        return this.minSelectableDate;
    }

    public Color getSundayForeground() {
        return this.sundayForeground;
    }

    public Color getWeekdayForeground() {
        return this.weekdayForeground;
    }

    protected void init() {
        JButton testButton = new JButton();
        this.defaultButtonBackgroundColor = testButton.getBackground();
        this.selectedColor = new Color(160, 160, 160);
        Date date = this.calendar.getTime();
        this.calendar = Calendar.getInstance(this.locale);
        this.calendar.setTime(date);
        this.initToday();
        this.updateDayNames();
        this.updateDays();
    }

    private void initToday() {
        if (this.todayUpdateTimer != null) {
            this.todayUpdateTimer.stop();
            this.todayUpdateTimer = null;
        }
        this.updateToday();
    }

    private void updateToday() {
        this.today = Calendar.getInstance(this.locale);
        this.updateDays();
        this.scheduleNextUpdateForTomorrow();
    }

    private void scheduleNextUpdateForTomorrow() {
        Calendar nextDay = (Calendar)this.today.clone();
        nextDay.set(11, 0);
        nextDay.set(12, 0);
        nextDay.set(13, 0);
        nextDay.set(14, 0);
        nextDay.add(6, 1);
        int delayInMillis = (int)(nextDay.getTimeInMillis() - this.today.getTimeInMillis());
        WeakReference<JDayChooser> dayChoserReference = new WeakReference<JDayChooser>(this);
        this.todayUpdateTimer = new Timer(delayInMillis + 1000, e -> Optional.ofNullable((JDayChooser)dayChoserReference.get()).ifPresent(JDayChooser::updateToday));
        this.todayUpdateTimer.setRepeats(false);
        this.todayUpdateTimer.start();
    }

    protected void initDecorations() {
        for (int x = 0; x < 7; ++x) {
            this.days[x].setContentAreaFilled(this.decorationBackgroundVisible);
            this.days[x].setBorderPainted(this.decorationBordersVisible);
            this.days[x].invalidate();
            this.days[x].repaint();
            this.weeks[x].setContentAreaFilled(this.decorationBackgroundVisible);
            this.weeks[x].setBorderPainted(this.decorationBordersVisible);
            this.weeks[x].invalidate();
            this.weeks[x].repaint();
        }
    }

    public boolean isDayBordersVisible() {
        return this.dayBordersVisible;
    }

    public boolean isDecorationBackgroundVisible() {
        return this.decorationBackgroundVisible;
    }

    public boolean isDecorationBordersVisible() {
        return this.decorationBordersVisible;
    }

    public boolean isWeekOfYearVisible() {
        return this.weekOfYearVisible;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int offset = e.getKeyCode() == 38 ? -7 : (e.getKeyCode() == 40 ? 7 : (e.getKeyCode() == 37 ? -1 : (e.getKeyCode() == 39 ? 1 : 0)));
        int newDay = this.getDay() + offset;
        if (newDay >= 1 && newDay <= this.calendar.getActualMaximum(5)) {
            this.setDay(newDay);
        } else if (this.monthChooser != null && this.yearChooser != null) {
            GregorianCalendar tempCalendar = new GregorianCalendar(this.yearChooser.getYear(), this.monthChooser.getMonth(), this.getDay());
            tempCalendar.add(5, offset);
            int month = tempCalendar.get(2);
            int year = tempCalendar.get(1);
            int day = tempCalendar.get(5);
            this.yearChooser.setYear(year);
            this.monthChooser.setMonth(month);
            this.setDay(day);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public void setAlwaysFireDayProperty(boolean alwaysFire) {
        this.alwaysFireDayProperty = alwaysFire;
    }

    public void setCalendar(Calendar calendar) {
        if (this.todayUpdateTimer != null) {
            this.todayUpdateTimer.stop();
            this.todayUpdateTimer = null;
        }
        this.calendar = calendar;
        this.today = (Calendar)calendar.clone();
        this.updateDays();
    }

    public void setDay(int d) {
        if (d < 1) {
            d = 1;
        }
        Calendar daysOfMonthCalculator = (Calendar)this.calendar.clone();
        daysOfMonthCalculator.set(5, 1);
        daysOfMonthCalculator.add(2, 1);
        daysOfMonthCalculator.add(5, -1);
        int maxDaysInMonth = daysOfMonthCalculator.get(5);
        if (d > maxDaysInMonth) {
            d = maxDaysInMonth;
        }
        int oldDay = this.day;
        this.day = d;
        if (this.isEnabled()) {
            if (this.selectedDay != null) {
                this.selectedDay.setBackground(this.selectedDay == this.todayButton ? this.todayBackground : this.defaultButtonBackgroundColor);
                this.selectedDay.paintImmediately(0, 0, this.selectedDay.getWidth(), this.selectedDay.getWidth());
            }
            for (int i = 7; i < 49; ++i) {
                if (!this.days[i].getText().equals(Integer.toString(this.day))) continue;
                this.selectedDay = this.days[i];
                this.selectedDay.setBackground(this.selectedColor);
                this.selectedDay.paintImmediately(0, 0, this.selectedDay.getWidth(), this.selectedDay.getWidth());
                break;
            }
        }
        if (this.alwaysFireDayProperty) {
            this.firePropertyChange(DAY_PROPERTY, 0, this.day);
        } else {
            this.firePropertyChange(DAY_PROPERTY, oldDay, this.day);
        }
    }

    public void setDayBordersVisible(boolean dayBordersVisible) {
        this.dayBordersVisible = dayBordersVisible;
        if (this.initialized) {
            for (int x = 7; x < 49; ++x) {
                if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
                    this.days[x].setContentAreaFilled(dayBordersVisible);
                } else {
                    this.days[x].setContentAreaFilled(true);
                }
                this.days[x].setBorderPainted(dayBordersVisible);
            }
        }
    }

    public void setDecorationBackgroundColor(Color decorationBackgroundColor) {
        int i;
        this.decorationBackgroundColor = decorationBackgroundColor;
        if (this.days != null) {
            for (i = 0; i < 7; ++i) {
                this.days[i].setBackground(decorationBackgroundColor);
            }
        }
        if (this.weeks != null) {
            for (i = 0; i < 7; ++i) {
                this.weeks[i].setBackground(decorationBackgroundColor);
            }
        }
    }

    public void setDecorationBackgroundVisible(boolean decorationBackgroundVisible) {
        this.decorationBackgroundVisible = decorationBackgroundVisible;
        this.initDecorations();
    }

    public void setDecorationBordersVisible(boolean decorationBordersVisible) {
        this.decorationBordersVisible = decorationBordersVisible;
        this.initDecorations();
    }

    @Override
    public void setEnabled(boolean enabled) {
        int i;
        super.setEnabled(enabled);
        for (i = 0; i < this.days.length; i = (int)((short)(i + 1))) {
            if (this.days[i] == null) continue;
            this.days[i].setEnabled(enabled);
        }
        for (i = 0; i < this.weeks.length; i = (int)((short)(i + 1))) {
            if (this.weeks[i] == null) continue;
            this.weeks[i].setEnabled(enabled);
        }
    }

    @Override
    public void setFont(Font font) {
        int i;
        if (this.days != null) {
            for (i = 0; i < 49; ++i) {
                this.days[i].setFont(font);
            }
        }
        if (this.weeks != null) {
            for (i = 0; i < 7; ++i) {
                this.weeks[i].setFont(font);
            }
        }
    }

    @Override
    public void setForeground(Color foreground) {
        super.setForeground(foreground);
        if (this.days != null) {
            for (int i = 7; i < 49; ++i) {
                this.days[i].setForeground(foreground);
            }
            this.updateDays();
        }
    }

    @Override
    public void setLocale(Locale locale) {
        if (!this.initialized) {
            super.setLocale(locale);
        } else {
            this.locale = locale;
            super.setLocale(locale);
            this.init();
        }
    }

    public void setMaxDayCharacters(int maxDayCharacters) {
        if (maxDayCharacters == this.maxDayCharacters) {
            return;
        }
        this.maxDayCharacters = maxDayCharacters < 0 || maxDayCharacters > 4 ? 0 : maxDayCharacters;
        this.updateDayNames();
        this.updateDays();
        this.invalidate();
    }

    public Date setMaxSelectableDate(Date max) {
        this.maxSelectableDate = max == null ? this.defaultMaxSelectableDate : max;
        this.updateDays();
        return this.maxSelectableDate;
    }

    public Date setMinSelectableDate(Date min) {
        this.minSelectableDate = min == null ? this.defaultMinSelectableDate : min;
        this.updateDays();
        return this.minSelectableDate;
    }

    public void setMonth(int month) {
        int maxDays = this.calendar.getActualMaximum(5);
        this.calendar.set(2, month);
        if (maxDays == this.day) {
            this.day = this.calendar.getActualMaximum(5);
        }
        boolean storedMode = this.alwaysFireDayProperty;
        this.alwaysFireDayProperty = false;
        this.setDay(this.day);
        this.alwaysFireDayProperty = storedMode;
        this.updateDays();
    }

    public void setMonthChooser(JMonthChooser monthChooser) {
        this.monthChooser = monthChooser;
    }

    public void setSelectableDateRange(Date min, Date max) {
        this.minSelectableDate = min == null ? this.defaultMinSelectableDate : min;
        this.maxSelectableDate = max == null ? this.defaultMaxSelectableDate : max;
        if (this.maxSelectableDate.before(this.minSelectableDate)) {
            this.minSelectableDate = this.defaultMinSelectableDate;
            this.maxSelectableDate = this.defaultMaxSelectableDate;
        }
        this.updateDays();
    }

    public void setSundayForeground(Color sundayForeground) {
        this.sundayForeground = sundayForeground;
        this.updateDayNames();
        this.updateDays();
    }

    public void setTodayBackground(Color todayBackground) {
        this.todayBackground = todayBackground;
        this.updateDays();
    }

    public void setWeekdayForeground(Color weekdayForeground) {
        this.weekdayForeground = weekdayForeground;
        this.updateDayNames();
        this.updateDays();
    }

    public void setWeekOfYearVisible(boolean weekOfYearVisible) {
        if (weekOfYearVisible == this.weekOfYearVisible) {
            return;
        }
        if (weekOfYearVisible) {
            this.add((Component)this.weekPanel, "West");
        } else {
            this.remove(this.weekPanel);
        }
        this.weekOfYearVisible = weekOfYearVisible;
        this.validate();
        this.dayPanel.validate();
    }

    public void setYear(int year) {
        this.calendar.set(1, year);
        this.updateDays();
    }

    public void setYearChooser(JYearChooser yearChooser) {
        this.yearChooser = yearChooser;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setFont(UITools.scale(Font.decode("Dialog Plain 11")));
        if (this.weekPanel != null) {
            this.weekPanel.updateUI();
        }
        if (this.initialized) {
            if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
                this.setDayBordersVisible(false);
                this.setDecorationBackgroundVisible(true);
                this.setDecorationBordersVisible(false);
            } else {
                this.setDayBordersVisible(true);
                this.setDecorationBackgroundVisible(this.decorationBackgroundVisible);
                this.setDecorationBordersVisible(this.decorationBordersVisible);
            }
        }
    }

    class DecoratorButton
    extends JDayButton {
        private static final long serialVersionUID = 1L;

        public DecoratorButton() {
            this.setBackground(JDayChooser.this.decorationBackgroundColor);
            this.setContentAreaFilled(JDayChooser.this.decorationBackgroundVisible);
            this.setBorderPainted(JDayChooser.this.decorationBordersVisible);
            this.setFocusable(false);
        }

        @Override
        public void paint(Graphics g) {
            if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
                if (JDayChooser.this.decorationBackgroundVisible) {
                    g.setColor(JDayChooser.this.decorationBackgroundColor);
                } else {
                    g.setColor(JDayChooser.this.days[7].getBackground());
                }
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                if (this.isBorderPainted()) {
                    this.setContentAreaFilled(true);
                } else {
                    this.setContentAreaFilled(false);
                }
            }
            super.paint(g);
        }
    }

    static class JDayButton
    extends JButton {
        private static final long serialVersionUID = 1L;

        JDayButton() {
        }

        @Override
        public void updateUI() {
            this.setMargin(new Insets(0, 0, 0, 0));
            super.updateUI();
            Insets insets = this.getInsets();
            if (insets.left + insets.right > 8) {
                this.setUI(BasicButtonUI.createUI(this));
                this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
            }
        }
    }
}

