/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Stream;
import javax.swing.SwingUtilities;
import org.freeplane.view.swing.map.NodeView;

class NodeViewFolder {
    private final Map<NodeView, Void> unfoldedNodeViews = new WeakHashMap<NodeView, Void>();

    NodeViewFolder() {
    }

    void adjustFolding(Set<NodeView> selectedNodeViews) {
        HashSet<NodeView> selectedNodeViewsWithAncestors = this.withAncestors(selectedNodeViews);
        NodeView[] toFold = (NodeView[])this.unfoldedNodeViews.keySet().stream().filter(nodeView -> !selectedNodeViewsWithAncestors.contains(nodeView) && SwingUtilities.isDescendingFrom(nodeView, nodeView.getMap())).toArray(NodeView[]::new);
        Stream.of(toFold).filter(nodeView -> nodeView.getNode().isFoldable()).forEach(nodeView -> nodeView.setFolded(true));
        if (toFold.length == this.unfoldedNodeViews.size()) {
            this.unfoldedNodeViews.clear();
        } else {
            Stream.of(toFold).forEach(this.unfoldedNodeViews::remove);
        }
        selectedNodeViews.stream().filter(nodeView -> nodeView.isFolded()).forEach(nodeView -> {
            nodeView.setFolded(false);
            this.unfoldedNodeViews.put((NodeView)nodeView, (Void)null);
        });
    }

    private HashSet<NodeView> withAncestors(Set<NodeView> nodeViews) {
        HashSet<NodeView> withAncestors = new HashSet<NodeView>();
        Iterator<NodeView> iterator = nodeViews.iterator();
        while (iterator.hasNext()) {
            NodeView nodeView;
            for (NodeView ancestor = nodeView = iterator.next(); ancestor != null && !withAncestors.contains(ancestor); ancestor = ancestor.getParentNodeView()) {
                withAncestors.add(ancestor);
            }
        }
        return withAncestors;
    }
}

