/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeGeometryModel;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MainViewPainter;
import org.freeplane.view.swing.map.NodeView;

abstract class ShapedPainter
extends MainViewPainter {
    private final NodeGeometryModel shapeConfiguration;

    ShapedPainter(MainView mainView, NodeGeometryModel shapeConfiguration) {
        super(mainView);
        this.shapeConfiguration = shapeConfiguration;
    }

    @Override
    NodeGeometryModel getShapeConfiguration() {
        return this.shapeConfiguration;
    }

    @Override
    public Point getLeftPoint() {
        Point in = new Point(0, this.mainView.getHeight() / 2);
        return in;
    }

    @Override
    public Point getRightPoint() {
        Point in = this.getLeftPoint();
        in.x = this.mainView.getWidth() - 1;
        return in;
    }

    @Override
    void paintComponent(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        NodeView nodeView = this.mainView.getNodeView();
        if (nodeView.getNode() == null) {
            return;
        }
        ModeController modeController = this.mainView.getNodeView().getMap().getModeController();
        Object renderingHint = modeController.getController().getMapViewManager().setEdgesRenderingHint(g);
        this.mainView.paintBackgound(g);
        this.mainView.paintDragOver(g);
        if (this.mainView.getBorderColor().getAlpha() != 0) {
            this.paintNodeShapeConfiguringGraphics(g);
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, renderingHint);
        super.paintComponent(g);
    }

    private void paintNodeShapeConfiguringGraphics(Graphics2D g) {
        Color borderColor = this.mainView.getBorderColor();
        Color oldColor = g.getColor();
        g.setColor(borderColor);
        Stroke oldStroke = g.getStroke();
        g.setStroke(UITools.createStroke(this.mainView.getPaintedBorderWidth(), this.mainView.getDash().pattern, 0));
        this.paintNodeShape(g);
        g.setColor(oldColor);
        g.setStroke(oldStroke);
    }

    abstract void paintNodeShape(Graphics2D var1);
}

