/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.map;

import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaClass;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.condition.ICondition;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.plugin.codeexplorer.map.AncestorsHider;
import org.freeplane.plugin.codeexplorer.map.CodeMap;
import org.freeplane.plugin.codeexplorer.map.CodeNode;
import org.freeplane.plugin.codeexplorer.map.CodeNodeSelection;
import org.freeplane.plugin.codeexplorer.map.DependencySelection;
import org.freeplane.plugin.codeexplorer.map.DependencySnapshotCondition;
import org.freeplane.view.swing.map.MapView;

class ShowDependingNodesAction
extends AFreeplaneAction {
    MapView mapView = (MapView)Controller.getCurrentController().getMapViewManager().getMapViewComponent();
    private DependencyDirection dependencyDirection;
    private CodeNodeSelection codeNodeSelection;
    private final int maximumRecursionDepth;

    private static Stream<JavaClass> dependentClasses(Dependency dependency) {
        JavaClass target;
        JavaClass origin = CodeNode.findEnclosingNamedClass(dependency.getOriginClass());
        return origin != (target = CodeNode.findEnclosingNamedClass(dependency.getTargetClass())) ? Stream.of(origin, target) : Stream.empty();
    }

    ShowDependingNodesAction(DependencyDirection dependencyDirection, CodeNodeSelection codeNodeSelection, Depth recursionDepth) {
        super("code.ShowDependingNodesAction." + (Object)((Object)dependencyDirection) + "." + (Object)((Object)codeNodeSelection) + "." + (Object)((Object)recursionDepth), ShowDependingNodesAction.formatActionText(dependencyDirection, codeNodeSelection, recursionDepth), null);
        this.dependencyDirection = dependencyDirection;
        this.codeNodeSelection = codeNodeSelection;
        this.maximumRecursionDepth = recursionDepth.depth;
    }

    private static String formatActionText(DependencyDirection dependencyDirection, CodeNodeSelection codeNodeSelection, Depth recursionDepth) {
        return TextUtils.format((String)("code.ShowDependingNodesAction." + (Object)((Object)recursionDepth) + ".text"), (Object[])new Object[]{TextUtils.getRawText((String)("code." + (Object)((Object)dependencyDirection))), TextUtils.getRawText((String)("code." + (Object)((Object)codeNodeSelection)))});
    }

    public void actionPerformed(ActionEvent e) {
        Set<String> dependentNodeIDs;
        IMapSelection selection = Controller.getCurrentController().getSelection();
        Filter lastFilter = selection.getFilter();
        ICondition currentCondition = lastFilter.getCondition();
        if (currentCondition == null) {
            return;
        }
        MapModel map = selection.getMap();
        if (this.dependencyDirection == DependencyDirection.INCOMING_AND_OUTGOING) {
            Set<String> incomingDependencies = this.recursiveDependencies(selection, currentCondition, map, DependencyDirection.INCOMING);
            Set<String> outgoingDependencies = this.recursiveDependencies(selection, currentCondition, map, DependencyDirection.OUTGOING);
            if (incomingDependencies.isEmpty()) {
                dependentNodeIDs = outgoingDependencies;
            } else {
                dependentNodeIDs = incomingDependencies;
                dependentNodeIDs.addAll(outgoingDependencies);
            }
        } else {
            dependentNodeIDs = this.recursiveDependencies(selection, currentCondition, map, this.dependencyDirection);
        }
        if (!dependentNodeIDs.isEmpty()) {
            this.codeNodeSelection.get().filter(node -> !currentCondition.checkNode((NodeModel)node)).map(NodeModel::getID).forEach(dependentNodeIDs::add);
            FilterController filterController = FilterController.getCurrentFilterController();
            DependencySnapshotCondition condition = new DependencySnapshotCondition(dependentNodeIDs, currentCondition);
            Filter filter = new Filter((ICondition)condition, false, true, lastFilter.areDescendantsShown(), false, null);
            filterController.applyFilter(map, false, filter);
            if (!lastFilter.areAncestorsShown()) {
                AncestorsHider.hideAncestors();
            }
        }
    }

    private Set<String> recursiveDependencies(IMapSelection selection, ICondition currentCondition, MapModel map, DependencyDirection dependencyDirection) {
        int recursionCounter;
        DependencySelection dependencySelection = new DependencySelection(selection);
        HashSet<String> dependentNodeIDs = ShowDependingNodesAction.dependencies((Stream<CodeNode>)this.codeNodeSelection.get(), dependencySelection.getMap(), dependencyDirection);
        int n = recursionCounter = this.allNodesSatisfyFilter(selection, dependentNodeIDs) ? 0 : 1;
        while (recursionCounter < this.maximumRecursionDepth) {
            HashSet<String> next = ShowDependingNodesAction.dependencies(dependentNodeIDs.stream().map(arg_0 -> ((MapModel)map).getNodeForID(arg_0)).map(CodeNode.class::cast), dependencySelection.getMap(), dependencyDirection);
            next.removeAll(dependentNodeIDs);
            if (next.isEmpty()) {
                if (recursionCounter != 0) break;
                return Collections.emptySet();
            }
            dependentNodeIDs.addAll(next);
            if (this.allNodesSatisfyFilter(selection, next)) {
                --recursionCounter;
            }
            ++recursionCounter;
        }
        dependentNodeIDs.removeIf(id -> currentCondition.checkNode(map.getNodeForID(id)));
        return dependentNodeIDs;
    }

    private boolean allNodesSatisfyFilter(IMapSelection selection, Set<String> dependentNodeIDs) {
        return dependentNodeIDs.stream().allMatch(id -> selection.getMap().getNodeForID(id).isVisible(selection.getFilter()));
    }

    private static HashSet<String> dependencies(Stream<CodeNode> startingNodes, CodeMap map, DependencyDirection dependencyDirection) {
        return startingNodes.flatMap(dependencyDirection.nodeDependencies).flatMap(ShowDependingNodesAction::dependentClasses).map(map::getClassNodeId).collect(Collectors.toCollection(HashSet::new));
    }

    static enum DependencyDirection {
        INCOMING(CodeNode::getIncomingDependenciesWithKnownOrigins),
        OUTGOING(CodeNode::getOutgoingDependenciesWithKnownTargets),
        INCOMING_AND_OUTGOING(CodeNode::getIncomingAndOutgoingDependenciesWithKnownTargets),
        CONNECTED(CodeNode::getIncomingAndOutgoingDependenciesWithKnownTargets);

        final Function<CodeNode, Stream<Dependency>> nodeDependencies;

        private DependencyDirection(Function<CodeNode, Stream<Dependency>> nodeDependencies) {
            this.nodeDependencies = nodeDependencies;
        }
    }

    static enum Depth {
        NO_RECURSION(1),
        MAXIMUM_RECURSION(10000);

        final int depth;

        private Depth(int depth) {
            this.depth = depth;
        }
    }
}

