/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.proxy;

import java.util.Objects;
import org.freeplane.api.ConditionalStyle;
import org.freeplane.api.ConditionalStyleRO;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.styles.ConditionalStyleModel;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.styles.mindmapmode.MLogicalStyleController;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.proxy.AConditionalStylesProxy;
import org.freeplane.plugin.script.proxy.MapConditionalStyleProxy;

public class MapConditionalStylesProxy
extends AConditionalStylesProxy<MapModel> {
    MapConditionalStylesProxy(MapModel delegate, ScriptContext scriptContext) {
        super(delegate, scriptContext);
    }

    MapConditionalStyleProxy createProxy(ConditionalStyleModel.Item item) {
        return new MapConditionalStyleProxy((MapModel)this.getDelegate(), item);
    }

    MapConditionalStyleProxy createProxy(boolean isActive, String script, String styleName, boolean isLast) {
        return new MapConditionalStyleProxy((MapModel)this.getDelegate(), isActive, script, styleName, isLast);
    }

    @Override
    ConditionalStyleModel getConditionalStyleModel() {
        return MapStyleModel.getExtension((MapModel)((MapModel)this.getDelegate())).getConditionalStyleModel();
    }

    public void add(ConditionalStyleRO conditionalStyle) {
        MapConditionalStyleProxy cs = (MapConditionalStyleProxy)Objects.requireNonNull(conditionalStyle, "ConditionalStyle mustn't be null");
        MLogicalStyleController controller = (MLogicalStyleController)LogicalStyleController.getController();
        controller.addConditionalStyle((MapModel)this.getDelegate(), this.getConditionalStyleModel(), cs.isActive(), cs.getCondition(), cs.getStyle(), cs.isLast());
        this.callDelayedRefresh((MapModel)this.getDelegate());
    }

    public void insert(int index, ConditionalStyleRO conditionalStyle) {
        MapConditionalStyleProxy cs = (MapConditionalStyleProxy)Objects.requireNonNull(conditionalStyle, "ConditionalStyle mustn't be null");
        MLogicalStyleController controller = (MLogicalStyleController)LogicalStyleController.getController();
        controller.insertConditionalStyle((MapModel)this.getDelegate(), this.getConditionalStyleModel(), index, cs.isActive(), cs.getCondition(), cs.getStyle(), cs.isLast());
        this.callDelayedRefresh((MapModel)this.getDelegate());
    }

    public void move(int index, int toIndex) {
        MLogicalStyleController controller = (MLogicalStyleController)LogicalStyleController.getController();
        controller.moveConditionalStyle((MapModel)this.getDelegate(), this.getConditionalStyleModel(), index, toIndex);
        this.callDelayedRefresh((MapModel)this.getDelegate());
    }

    public ConditionalStyle remove(int index) {
        MLogicalStyleController controller = (MLogicalStyleController)LogicalStyleController.getController();
        ConditionalStyleModel.Item item = controller.removeConditionalStyle(this.getConditionalStyleModel(), index);
        this.callDelayedRefresh((MapModel)this.getDelegate());
        return new MapConditionalStyleProxy((MapModel)this.getDelegate(), item);
    }

    private void callDelayedRefresh(MapModel map) {
        LogicalStyleController.getController().refreshMapLaterUndoable(map);
    }
}

