/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.proxy;

import java.awt.Color;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.freeplane.api.HorizontalTextAlignment;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.MindMap;
import org.freeplane.api.Quantity;
import org.freeplane.core.resources.TranslatedObject;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.nodestyle.NodeCss;
import org.freeplane.features.nodestyle.NodeSizeModel;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.NodeStyleModel;
import org.freeplane.features.nodestyle.mindmapmode.MNodeStyleController;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.LogicalStyleModel;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.styles.StyleFactory;
import org.freeplane.features.styles.StyleTranslatedObject;
import org.freeplane.features.styles.mindmapmode.MLogicalStyleController;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.proxy.AbstractProxy;
import org.freeplane.plugin.script.proxy.BorderProxy;
import org.freeplane.plugin.script.proxy.EdgeProxy;
import org.freeplane.plugin.script.proxy.FontProxy;
import org.freeplane.plugin.script.proxy.MapProxy;
import org.freeplane.plugin.script.proxy.NodeProxy;
import org.freeplane.plugin.script.proxy.Proxy;

class NodeStyleProxy
extends AbstractProxy<NodeModel>
implements Proxy.NodeStyle {
    static final String STYLE_NAME_MUST_NOT_BE_NULL = "styleName mustn't be null";

    static IStyle styleByName(MindMap map, String styleName) {
        return NodeStyleProxy.styleByName((MapModel)((MapProxy)map).getDelegate(), styleName);
    }

    static IStyle styleByName(MapModel map, String styleName) {
        IStyle styleString;
        MapStyleModel sourceStyleModel = MapStyleModel.getExtension((MapModel)map);
        IStyle sourceStyle = null;
        Set styles = sourceStyleModel.getStyles();
        if (styles.contains(styleString = StyleFactory.create((String)styleName))) {
            sourceStyle = styleString;
        } else {
            IStyle styleNamedObject = StyleFactory.create((TranslatedObject)new TranslatedObject(styleName));
            if (styles.contains(styleNamedObject)) {
                sourceStyle = styleNamedObject;
            } else {
                for (IStyle style : styles) {
                    if (!style.toString().equals(styleName)) continue;
                    sourceStyle = style;
                    break;
                }
            }
        }
        return sourceStyle;
    }

    static IStyle styleByNameOrThrowException(MapModel map, String styleName) {
        IStyle style = NodeStyleProxy.styleByName(map, Objects.requireNonNull(styleName, STYLE_NAME_MUST_NOT_BE_NULL));
        if (style == null) {
            throw new IllegalArgumentException("style '" + styleName + "' not found");
        }
        return style;
    }

    NodeStyleProxy(NodeModel delegate, ScriptContext scriptContext) {
        super(delegate, scriptContext);
    }

    @Override
    public IStyle getStyle() {
        return LogicalStyleModel.getStyle((NodeModel)((NodeModel)this.getDelegate()));
    }

    public List<String> getAllActiveStyles() {
        return this.getLogicalStyleController().getStyles((NodeModel)this.getDelegate(), LogicalStyleController.StyleOption.STYLES_ONLY).stream().map(StyleTranslatedObject::toKeyString).collect(Collectors.toList());
    }

    public String getName() {
        IStyle style = this.getStyle();
        return style == null ? null : StyleTranslatedObject.toKeyString((IStyle)style);
    }

    public Proxy.Node getStyleNode() {
        NodeModel styleNode = MapStyleModel.getExtension((MapModel)((NodeModel)this.getDelegate()).getMap()).getStyleNode(this.getStyle());
        return new NodeProxy(styleNode, this.getScriptContext());
    }

    public Color getBackgroundColor() {
        return this.getStyleController().getBackgroundColor((NodeModel)this.getDelegate(), LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
    }

    public String getBackgroundColorCode() {
        return ColorUtils.colorToString((Color)this.getBackgroundColor());
    }

    public Proxy.Edge getEdge() {
        return new EdgeProxy((NodeModel)this.getDelegate(), this.getScriptContext());
    }

    public Proxy.Border getBorder() {
        return new BorderProxy((NodeModel)this.getDelegate(), this.getScriptContext());
    }

    public Proxy.Font getFont() {
        return new FontProxy((NodeModel)this.getDelegate(), this.getScriptContext());
    }

    public Color getTextColor() {
        return this.getStyleController().getColor((NodeModel)this.getDelegate(), LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
    }

    @Deprecated
    public Color getNodeTextColor() {
        return this.getTextColor();
    }

    public String getTextColorCode() {
        return ColorUtils.colorToString((Color)this.getTextColor());
    }

    public boolean isFloating() {
        return NodeStyleProxy.hasStyle((NodeModel)this.getDelegate(), StyleTranslatedObject.toKeyString((IStyle)MapStyleModel.FLOATING_STYLE));
    }

    public int getMinNodeWidth() {
        return this.getMinNodeWidthQuantity().toBaseUnitsRounded();
    }

    public Quantity<LengthUnit> getMinNodeWidthQuantity() {
        return this.getStyleController().getMinWidth((NodeModel)this.getDelegate(), LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
    }

    public int getMaxNodeWidth() {
        return this.getMaxNodeWidthQuantity().toBaseUnitsRounded();
    }

    public Quantity<LengthUnit> getMaxNodeWidthQuantity() {
        return this.getStyleController().getMaxWidth((NodeModel)this.getDelegate(), LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
    }

    private MLogicalStyleController getLogicalStyleController() {
        return (MLogicalStyleController)LogicalStyleController.getController();
    }

    private MNodeStyleController getStyleController() {
        return (MNodeStyleController)NodeStyleController.getController();
    }

    @Override
    public void setStyle(IStyle key) {
        this.getLogicalStyleController().setStyle((NodeModel)this.getDelegate(), key);
    }

    public void setName(String styleName) {
        if (styleName == null) {
            this.setStyle(null);
        } else {
            IStyle style = NodeStyleProxy.styleByName(((NodeModel)this.getDelegate()).getMap(), styleName);
            if (style == null) {
                throw new IllegalArgumentException("style '" + styleName + "' not found");
            }
            this.setStyle(style);
        }
    }

    public void setBackgroundColor(Color color) {
        this.getStyleController().setBackgroundColor((NodeModel)this.getDelegate(), color);
    }

    public void setBackgroundColorCode(String rgbString) {
        this.setBackgroundColor(ColorUtils.stringToColor((String)rgbString));
    }

    public void setTextColor(Color color) {
        this.getStyleController().setColor((NodeModel)this.getDelegate(), color);
    }

    @Deprecated
    public void setNodeTextColor(Color color) {
        this.setTextColor(color);
    }

    public void setTextColorCode(String rgbString) {
        this.setTextColor(ColorUtils.stringToColor((String)rgbString));
    }

    public void setFloating(boolean floating) {
        if (floating) {
            this.setStyle(MapStyleModel.FLOATING_STYLE);
        } else if (MapStyleModel.FLOATING_STYLE.equals(this.getStyle())) {
            this.setStyle(null);
        }
    }

    public static boolean hasStyle(NodeModel nodeModel, String styleName) {
        Collection styles = LogicalStyleController.getController().getStyles(nodeModel, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
        for (IStyle style : styles) {
            if (!StyleTranslatedObject.toKeyString((IStyle)style).equals(styleName)) continue;
            return true;
        }
        return false;
    }

    public void setMinNodeWidth(int width) {
        Quantity<LengthUnit> quantity = this.inPixels(width);
        this.setMinNodeWidth(quantity);
    }

    public Quantity<LengthUnit> inPixels(int width) {
        Quantity quantity = width != -1 ? new Quantity((double)width, (Enum)LengthUnit.px) : null;
        return quantity;
    }

    @Override
    public void setMinNodeWidth(Quantity<LengthUnit> width) {
        this.getStyleController().setMinNodeWidth((NodeModel)this.getDelegate(), width);
    }

    public void setMinNodeWidth(String width) {
        this.getStyleController().setMinNodeWidth((NodeModel)this.getDelegate(), Quantity.fromString((String)width, (Enum)LengthUnit.px));
    }

    public void setMaxNodeWidth(int width) {
        Quantity<LengthUnit> quantity = this.inPixels(width);
        this.setMaxNodeWidth(quantity);
    }

    @Override
    public void setMaxNodeWidth(Quantity<LengthUnit> width) {
        this.getStyleController().setMaxNodeWidth((NodeModel)this.getDelegate(), width);
    }

    public void setMaxNodeWidth(String width) {
        this.getStyleController().setMaxNodeWidth((NodeModel)this.getDelegate(), Quantity.fromString((String)width, (Enum)LengthUnit.px));
    }

    public boolean isNumberingEnabled() {
        return NodeStyleModel.getNodeNumbering((NodeModel)((NodeModel)this.getDelegate()));
    }

    public void setNumberingEnabled(boolean enabled) {
        this.getStyleController().setNodeNumbering((NodeModel)this.getDelegate(), Boolean.valueOf(enabled));
    }

    public void setCss(String css) {
        this.getStyleController().setStyleSheet((NodeModel)this.getDelegate(), css);
    }

    public String getCss() {
        String css = this.getStyleController().getStyleSheet((NodeModel)((NodeModel)this.getDelegate()), (LogicalStyleController.StyleOption)LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE).css;
        return css;
    }

    public boolean isCssSet() {
        return ((NodeModel)this.getDelegate()).getExtension(NodeCss.class) != null;
    }

    public boolean isBackgroundColorSet() {
        return NodeStyleModel.getBackgroundColor((NodeModel)((NodeModel)this.getDelegate())) != null;
    }

    public boolean isTextColorSet() {
        return NodeStyleModel.getColor((NodeModel)((NodeModel)this.getDelegate())) != null;
    }

    public boolean isMinNodeWidthSet() {
        return NodeSizeModel.getMinNodeWidth((NodeModel)((NodeModel)this.getDelegate())) != null;
    }

    public boolean isMaxNodeWidthSet() {
        return NodeSizeModel.getMaxNodeWidth((NodeModel)((NodeModel)this.getDelegate())) != null;
    }

    public boolean isHorizontalTextAlignmentSet() {
        return NodeStyleModel.getHorizontalTextAlignment((NodeModel)((NodeModel)this.getDelegate())) != null;
    }

    public HorizontalTextAlignment getHorizontalTextAlignment() {
        return this.getStyleController().getHorizontalTextAlignment((NodeModel)this.getDelegate(), LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
    }

    public void setHorizontalTextAlignment(HorizontalTextAlignment alignment) {
        this.getStyleController().setHorizontalTextAlignment((NodeModel)this.getDelegate(), alignment);
    }
}

