/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import com.lightdev.app.shtm.AttributeComponent;
import com.lightdev.app.shtm.DocumentPane;
import com.lightdev.app.shtm.SHTMLDocument;
import com.lightdev.app.shtm.SHTMLPanelImpl;
import com.lightdev.app.shtm.Util;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;

class StyleSelector
extends JComboBox
implements AttributeComponent,
ChangeListener {
    private final SHTMLPanelImpl shtmlPanel;
    private final HTML.Attribute key;
    private final boolean ignoreChanges = false;
    private final String standardStyleName = Util.getResourceString("standardStyleName");
    private String paragraphType;
    private boolean updateRunning;

    public StyleSelector(SHTMLPanelImpl shtmlPanel, HTML.Attribute key) {
        this.key = key;
        this.shtmlPanel = shtmlPanel;
        this.updateRunning = false;
    }

    @Override
    public boolean setValue(AttributeSet a) {
        boolean success = false;
        Object attr = a.getAttribute(this.key);
        if (attr != null) {
            this.setSelectedItem(attr.toString());
            success = true;
        } else {
            this.setSelectedItem(this.standardStyleName);
        }
        return success;
    }

    @Override
    public AttributeSet getValue() {
        SimpleAttributeSet set = new SimpleAttributeSet();
        set.addAttribute(this.key, this.getSelectedItem());
        return set;
    }

    @Override
    public AttributeSet getValue(boolean includeUnchanged) {
        return this.getValue();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.paragraphType = null;
        this.update();
    }

    @Override
    protected void fireActionEvent() {
        if (this.updateRunning) {
            return;
        }
        super.fireActionEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        try {
            this.updateRunning = true;
            DocumentPane currentDocumentPane = this.shtmlPanel.getCurrentDocumentPane();
            int selectionStart = currentDocumentPane.getEditor().getSelectionStart();
            SHTMLDocument document = currentDocumentPane.getDocument();
            String newParagraphType = document.getParagraphElement(selectionStart, true).getName();
            if (this.paragraphType == newParagraphType) {
                return;
            }
            this.paragraphType = newParagraphType;
            Vector styleNames = Util.getStyleNamesForTag(document.getStyleSheet(), this.paragraphType);
            styleNames.insertElementAt(this.standardStyleName, 0);
            this.setModel(new DefaultComboBoxModel(styleNames));
        }
        catch (NullPointerException ex) {
            this.setModel(new DefaultComboBoxModel());
        }
        finally {
            this.updateRunning = false;
        }
    }
}

