/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.util.collection;

import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import org.freeplane.core.util.collection.IListModel;

public class SortedComboBoxModel
extends AbstractListModel
implements ComboBoxModel,
IListModel,
Iterable<Object> {
    private static final long serialVersionUID = 1L;
    private Object selectedItem;
    private final SortedMap<Comparator, Object> model = new TreeMap<Comparator, Object>();

    @Override
    public void add(Object element) {
        if (this.addImpl(element)) {
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }

    private boolean addImpl(Object element) {
        Comparator key = this.key(element);
        if (this.model.containsKey(key)) {
            return false;
        }
        this.model.put(key, element);
        return true;
    }

    private Comparator key(Object o) {
        return new Comparator(o);
    }

    public void addAll(Object[] elements) {
        for (Object e : elements) {
            this.addImpl(e);
        }
        this.fireContentsChanged(this, 0, this.getSize());
    }

    @Override
    public void clear() {
        int oldSize = this.getSize();
        if (oldSize > 0) {
            this.model.clear();
            this.fireIntervalRemoved(this, 0, oldSize - 1);
        }
    }

    @Override
    public boolean contains(Object element) {
        return this.model.containsKey(this.key(element));
    }

    public Object firstElement() {
        return this.model.get(this.model.firstKey());
    }

    public Object getElementAt(int index) {
        return this.model.values().toArray()[index];
    }

    @Override
    public int getIndexOf(Object o) {
        int count = -1;
        for (Object element : this) {
            ++count;
            if (!element.equals(o)) continue;
            return count;
        }
        return -1;
    }

    @Override
    public int getSize() {
        return this.model.size();
    }

    @Override
    public Iterator<Object> iterator() {
        return this.model.values().iterator();
    }

    public Object lastElement() {
        return this.model.get(this.model.lastKey());
    }

    @Override
    public void remove(Object element) {
        if (null != this.model.remove(this.key(element))) {
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }

    @Override
    public void replace(Object oldO, Object newO) {
        if (oldO.equals(newO)) {
            return;
        }
        boolean removed = null != this.model.remove(this.key(oldO));
        boolean added = this.addImpl(newO);
        if (removed || added) {
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public void setSelectedItem(Object o) {
        this.selectedItem = o;
        this.fireContentsChanged(this, -1, -1);
    }

    private static class Comparator
    implements Comparable<Object> {
        private final Object obj;

        private Comparator(Object obj) {
            this.obj = obj;
        }

        @Override
        public int compareTo(Object o) {
            return this.compareTo((Comparator)o);
        }

        @Override
        private int compareTo(Comparator o) {
            int stringCompare = this.obj.toString().compareTo(o.obj.toString());
            if (stringCompare != 0) {
                return stringCompare;
            }
            int typeCompare = this.obj.getClass().getName().compareTo(o.obj.getClass().getName());
            return typeCompare;
        }

        public int hashCode() {
            return this.obj.hashCode();
        }

        public boolean equals(Object o) {
            return this.obj.getClass().equals(o.getClass()) && this.obj.equals(((Comparator)o).obj);
        }

        public String toString() {
            return this.obj.toString();
        }
    }
}

