/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.util.logging.internal;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

class StdFormatter
extends SimpleFormatter {
    public static final Level STDERR = new StdOutErrLevel("STDERR", Level.SEVERE.intValue());
    public static final Level STDOUT = new StdOutErrLevel("STDOUT", Level.WARNING.intValue());
    private final String lineSeparator = System.getProperty("line.separator");

    StdFormatter() {
    }

    @Override
    public synchronized String format(LogRecord record) {
        if (!STDERR.getName().equals(record.getLevel().getName()) && !STDOUT.getName().equals(record.getLevel().getName())) {
            return super.format(record);
        }
        StringBuilder sb = new StringBuilder();
        String message = this.formatMessage(record);
        sb.append(record.getLevel().getLocalizedName());
        sb.append(": ");
        sb.append(message.trim());
        sb.append(this.lineSeparator);
        return sb.toString();
    }

    private static class StdOutErrLevel
    extends Level {
        private static final long serialVersionUID = 1L;

        public StdOutErrLevel(String name, int value) {
            super(name, value);
        }
    }
}

