/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.attribute;

import org.freeplane.core.util.TextUtils;
import org.freeplane.features.attribute.AttributeConditionController;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.ConditionFactory;
import org.freeplane.features.map.NodeModel;
import org.freeplane.n3.nanoxml.XMLElement;

public class AttributeExistsCondition
extends ASelectableCondition {
    static final String ATTRIBUTE = "ATTRIBUTE";
    static final String NAME = "attribute_exists_condition";
    private final Object attribute;

    static ASelectableCondition load(XMLElement element) {
        return new AttributeExistsCondition(AttributeConditionController.toAttributeObject(element.getAttribute(ATTRIBUTE, null)));
    }

    public AttributeExistsCondition(Object attribute) {
        this.attribute = attribute;
    }

    @Override
    public boolean checkNode(NodeModel node) {
        NodeAttributeTableModel attributes = NodeAttributeTableModel.getModel(node);
        for (int i = 0; i < attributes.getRowCount(); ++i) {
            if (this.attribute.equals(AttributeConditionController.ANY_ATTRIBUTE_NAME_OR_VALUE_OBJECT)) {
                return true;
            }
            if (!attributes.getValueAt(i, 0).equals(this.attribute)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String createDescription() {
        String simpleCondition = TextUtils.getText("filter_exist");
        return ConditionFactory.createDescription(this.attribute.toString(), simpleCondition, null);
    }

    @Override
    public void fillXML(XMLElement child) {
        super.fillXML(child);
        if (this.attribute instanceof String) {
            child.setAttribute(ATTRIBUTE, (String)this.attribute);
        }
    }

    @Override
    protected String getName() {
        return NAME;
    }
}

