/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link;

import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.freeplane.core.resources.TranslatedObject;
import org.freeplane.core.ui.FixedBasicComboBoxEditor;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.DefaultConditionRenderer;
import org.freeplane.features.filter.condition.IElementaryConditionController;
import org.freeplane.features.link.ConnectorExistsCondition;
import org.freeplane.features.link.ConnectorLabelContainsCondition;
import org.freeplane.features.link.ConnectorLabelEqualsCondition;
import org.freeplane.features.link.ConnectorStyleCondition;
import org.freeplane.features.link.HyperLinkContainsCondition;
import org.freeplane.features.link.HyperLinkEqualsCondition;
import org.freeplane.features.link.HyperLinkExistsCondition;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.n3.nanoxml.XMLElement;

public class LinkConditionController
implements IElementaryConditionController {
    static final String FILTER_LINK = "filter_link";
    static final String CONNECTOR_LABEL = "connector_label";
    static final String CONNECTOR = "connector";
    private final DefaultComboBoxModel values = new DefaultComboBoxModel();

    @Override
    public boolean canEditValues(Object property, TranslatedObject simpleCond) {
        return !simpleCond.objectEquals("filter_exist") && !simpleCond.objectEquals("filter_style");
    }

    @Override
    public boolean canHandle(Object selectedItem) {
        if (!(selectedItem instanceof TranslatedObject)) {
            return false;
        }
        TranslatedObject namedObject = (TranslatedObject)selectedItem;
        return namedObject.objectEquals(FILTER_LINK) || namedObject.objectEquals(CONNECTOR_LABEL) || namedObject.objectEquals(CONNECTOR);
    }

    @Override
    public boolean canSelectValues(Object property, TranslatedObject simpleCond) {
        return !simpleCond.objectEquals("filter_exist");
    }

    @Override
    public ASelectableCondition createCondition(Object selectedItem, TranslatedObject simpleCond, Object value, boolean matchCase, boolean matchApproximately, boolean ignoreDiacritics) {
        TranslatedObject namedObject = (TranslatedObject)selectedItem;
        if (namedObject.objectEquals(FILTER_LINK)) {
            if (simpleCond.objectEquals("filter_is_equal_to")) {
                return new HyperLinkEqualsCondition((String)value, matchCase, matchApproximately, ignoreDiacritics);
            }
            if (simpleCond.objectEquals("filter_contains")) {
                return new HyperLinkContainsCondition((String)value, matchCase, matchApproximately, false, ignoreDiacritics);
            }
            if (simpleCond.objectEquals("filter_contains_wordwise")) {
                return new HyperLinkContainsCondition((String)value, matchCase, matchApproximately, true, ignoreDiacritics);
            }
            if (simpleCond.objectEquals("filter_exist")) {
                return new HyperLinkExistsCondition();
            }
            return null;
        }
        if (namedObject.objectEquals(CONNECTOR_LABEL)) {
            if (simpleCond.objectEquals("filter_is_equal_to")) {
                return new ConnectorLabelEqualsCondition((String)value, matchCase, matchApproximately, ignoreDiacritics);
            }
            if (simpleCond.objectEquals("filter_contains")) {
                return new ConnectorLabelContainsCondition((String)value, matchCase, matchApproximately, false, ignoreDiacritics);
            }
            if (simpleCond.objectEquals("filter_contains_wordwise")) {
                return new ConnectorLabelContainsCondition((String)value, matchCase, matchApproximately, true, ignoreDiacritics);
            }
            return null;
        }
        if (namedObject.objectEquals(CONNECTOR)) {
            if (simpleCond.objectEquals("filter_exist")) {
                return new ConnectorExistsCondition();
            }
            if (simpleCond.objectEquals("filter_style")) {
                return new ConnectorStyleCondition((IStyle)value);
            }
        }
        return null;
    }

    @Override
    public ComboBoxModel getConditionsForProperty(Object property) {
        TranslatedObject no = (TranslatedObject)property;
        TranslatedObject[] linkConditionNames = no.getObject().equals(FILTER_LINK) ? new TranslatedObject[]{TextUtils.createTranslatedString("filter_is_equal_to"), TextUtils.createTranslatedString("filter_contains"), TextUtils.createTranslatedString("filter_contains_wordwise"), TextUtils.createTranslatedString("filter_exist")} : (no.getObject().equals(CONNECTOR_LABEL) ? new TranslatedObject[]{TextUtils.createTranslatedString("filter_is_equal_to"), TextUtils.createTranslatedString("filter_contains")} : new TranslatedObject[]{TextUtils.createTranslatedString("filter_exist"), TextUtils.createTranslatedString("filter_style")});
        return new DefaultComboBoxModel<TranslatedObject>(linkConditionNames);
    }

    @Override
    public ListModel getFilteredProperties() {
        DefaultListModel<TranslatedObject> list = new DefaultListModel<TranslatedObject>();
        list.addElement(TextUtils.createTranslatedString(FILTER_LINK));
        list.addElement(TextUtils.createTranslatedString(CONNECTOR_LABEL));
        list.addElement(TextUtils.createTranslatedString(CONNECTOR));
        return list;
    }

    @Override
    public ComboBoxEditor getValueEditor(Object selectedProperty, TranslatedObject selectedCondition) {
        return new FixedBasicComboBoxEditor();
    }

    @Override
    public ComboBoxModel getValuesForProperty(Object property, TranslatedObject simpleCond) {
        if (simpleCond.objectEquals("filter_style")) {
            MapModel map = Controller.getCurrentController().getMap();
            MapStyleModel styleMap = MapStyleModel.getExtension(map);
            IStyle[] styles = (IStyle[])styleMap.getStyles().stream().filter(key -> NodeLinks.getSelfConnector(styleMap.getStyleNode((IStyle)key)).isPresent()).toArray(IStyle[]::new);
            return new DefaultComboBoxModel<IStyle>(styles);
        }
        return this.values;
    }

    @Override
    public boolean isCaseDependent(Object property, TranslatedObject simpleCond) {
        return ((TranslatedObject)property).objectEquals(CONNECTOR_LABEL) || ((TranslatedObject)property).objectEquals(FILTER_LINK);
    }

    @Override
    public boolean supportsApproximateMatching(Object property, TranslatedObject simpleCond) {
        return ((TranslatedObject)property).objectEquals(CONNECTOR_LABEL) || ((TranslatedObject)property).objectEquals(FILTER_LINK);
    }

    @Override
    public ASelectableCondition loadCondition(XMLElement element) {
        if (element.getName().equalsIgnoreCase("hyper_link_equals")) {
            String target = element.getAttribute("TEXT", null);
            boolean matchCase = Boolean.toString(true).equals(element.getAttribute("MATCH_CASE", null));
            boolean matchApproximately = Boolean.toString(true).equals(element.getAttribute("MATCH_APPROXIMATELY", null));
            return new HyperLinkEqualsCondition(target, matchCase, matchApproximately, (boolean)Boolean.valueOf(element.getAttribute("IGNORE_DIACRITICS", null)));
        }
        if (element.getName().equalsIgnoreCase("hyper_link_contains")) {
            String target = element.getAttribute("TEXT", null);
            boolean matchCase = Boolean.toString(true).equals(element.getAttribute("MATCH_CASE", null));
            boolean matchApproximately = Boolean.toString(true).equals(element.getAttribute("MATCH_APPROXIMATELY", null));
            boolean matchWordwise = Boolean.toString(true).equals(element.getAttribute("MATCH_WORDWISE", null));
            return new HyperLinkContainsCondition(target, matchCase, matchApproximately, matchWordwise, Boolean.valueOf(element.getAttribute("IGNORE_DIACRITICS", null)));
        }
        if (element.getName().equalsIgnoreCase("hyper_link_exists")) {
            return new HyperLinkExistsCondition();
        }
        if (element.getName().equalsIgnoreCase("connector_label_equals")) {
            String text = element.getAttribute("TEXT", null);
            boolean matchCase = Boolean.toString(true).equals(element.getAttribute("MATCH_CASE", null));
            boolean matchApproximately = Boolean.toString(true).equals(element.getAttribute("MATCH_APPROXIMATELY", null));
            return new ConnectorLabelEqualsCondition(text, matchCase, matchApproximately, (boolean)Boolean.valueOf(element.getAttribute("IGNORE_DIACRITICS", null)));
        }
        if (element.getName().equalsIgnoreCase("connector_label_contains")) {
            String text = element.getAttribute("TEXT", null);
            boolean matchCase = Boolean.toString(true).equals(element.getAttribute("MATCH_CASE", null));
            boolean matchApproximately = Boolean.toString(true).equals(element.getAttribute("MATCH_APPROXIMATELY", null));
            boolean matchWordwise = Boolean.toString(true).equals(element.getAttribute("MATCH_WORDWISE", null));
            return new ConnectorLabelContainsCondition(text, matchCase, matchApproximately, matchWordwise, Boolean.valueOf(element.getAttribute("IGNORE_DIACRITICS", null)));
        }
        if (element.getName().equalsIgnoreCase("connector_exists")) {
            return new ConnectorExistsCondition();
        }
        if (element.getName().equalsIgnoreCase("connector_style_equals")) {
            return ConnectorStyleCondition.load(element);
        }
        return null;
    }

    @Override
    public ListCellRenderer getValueRenderer(Object selectedProperty, TranslatedObject selectedCondition) {
        if (((TranslatedObject)selectedProperty).objectEquals(CONNECTOR) || ((TranslatedObject)selectedProperty).objectEquals(FILTER_LINK) && selectedCondition.objectEquals("filter_exist")) {
            return new DefaultConditionRenderer("", true);
        }
        return null;
    }
}

