/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.freeplane.core.extension.ExtensionContainer;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.icon.IconRegistry;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.INodeDuplicator;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeChangeAnnouncer;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;

public class MapModel {
    private static Random ran = new Random();
    private static final int UNDEFINED_NODE_ID = 2000000000;
    protected int changesPerformedSinceLastSave = 0;
    private final ExtensionContainer extensionContainer;
    private IconRegistry iconRegistry;
    private final List<IMapChangeListener> listeners;
    private final Map<String, NodeModel> nodes;
    private boolean readOnly = false;
    private NodeModel root;
    private URL url;
    private NodeChangeAnnouncer nodeChangeAnnouncer;
    private final INodeDuplicator nodeDuplicator;

    public MapModel(INodeDuplicator nodeDuplicator, IconRegistry iconRegistry, NodeChangeAnnouncer nodeChangeAnnouncer) {
        this.nodeDuplicator = nodeDuplicator;
        this.extensionContainer = new ExtensionContainer(new HashMap<Class<? extends IExtension>, IExtension>());
        this.root = null;
        this.listeners = new LinkedList<IMapChangeListener>();
        this.nodes = this.createNodeByIdMap();
        this.iconRegistry = iconRegistry;
        this.nodeChangeAnnouncer = nodeChangeAnnouncer;
    }

    protected Map<String, NodeModel> createNodeByIdMap() {
        return new HashMap<String, NodeModel>();
    }

    public MapModel(INodeDuplicator nodeDuplicator) {
        this(nodeDuplicator, null, null);
        ModeController modeController = Controller.getCurrentModeController();
        MapController mapController = modeController.getMapController();
        this.iconRegistry = new IconRegistry(mapController, this);
        this.nodeChangeAnnouncer = mapController;
    }

    public void createNewRoot() {
        this.root = new NodeModel(TextUtils.getText("new_mindmap"), this);
        this.root.attach();
    }

    public void addExtension(Class<? extends IExtension> clazz, IExtension extension) {
        this.extensionContainer.addExtension(clazz, extension);
    }

    public void addExtension(IExtension extension) {
        this.extensionContainer.addExtension(extension);
    }

    public <T extends IExtension> T putExtension(Class<? extends IExtension> clazz, IExtension extension) {
        return (T)this.extensionContainer.putExtension(clazz, extension);
    }

    public IExtension putExtension(IExtension extension) {
        return this.extensionContainer.putExtension(extension);
    }

    public boolean containsExtension(Class<? extends IExtension> clazz) {
        return this.extensionContainer.containsExtension(clazz);
    }

    public void addMapChangeListener(IMapChangeListener listener) {
        this.listeners.add(listener);
    }

    public void releaseResources() {
    }

    public void fireMapChangeEvent(MapChangeEvent event) {
        for (IMapChangeListener listener : this.listeners) {
            listener.mapChanged(event);
        }
    }

    public String generateNodeID(String proposedID) {
        String returnValue;
        if (proposedID != null && !"".equals(proposedID) && this.getNodeForID(proposedID) == null) {
            return proposedID;
        }
        do {
            String prefix = "ID_";
        } while (this.nodes.containsKey(returnValue = "ID_" + Integer.toString(ran.nextInt(2000000000))));
        return returnValue;
    }

    public <T extends IExtension> T getExtension(Class<T> clazz) {
        return this.extensionContainer.getExtension(clazz);
    }

    public Map<Class<? extends IExtension>, IExtension> getExtensions() {
        return this.extensionContainer.getExtensions();
    }

    public File getFile() {
        return this.url != null ? Compat.urlToFile(this.url) : null;
    }

    public IconRegistry getIconRegistry() {
        return this.iconRegistry;
    }

    public NodeModel getNodeForID(String nodeID) {
        NodeModel node = this.nodes.get(nodeID);
        return node;
    }

    public int getNumberOfChangesSinceLastSave() {
        return this.changesPerformedSinceLastSave;
    }

    public NodeModel getRootNode() {
        return this.root;
    }

    public String getTitle() {
        if (this.getURL() == null) {
            return null;
        }
        return this.getURL().toString();
    }

    public URL getURL() {
        return this.url;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isSaved() {
        return this.changesPerformedSinceLastSave == 0;
    }

    void registryID(String value, NodeModel nodeModel) {
        NodeModel old = this.nodes.put(value, nodeModel);
        if (null != old && nodeModel != old) {
            throw new RuntimeException("id " + value + " already registered");
        }
    }

    public String registryNode(NodeModel nodeModel) {
        String id = this.generateNodeID(nodeModel.getID());
        this.registryID(id, nodeModel);
        return id;
    }

    public void registryNodeRecursive(NodeModel nodeModel) {
        this.registryNodeRecursive(nodeModel, 0);
    }

    private void registryNodeRecursive(NodeModel nodeModel, int depth) {
        if (depth > 400) {
            throw new StackOverflowError();
        }
        String id = nodeModel.getID();
        if (id != null) {
            this.registryID(id, nodeModel);
        }
        for (NodeModel next : nodeModel.getChildren()) {
            this.registryNodeRecursive(next, depth + 1);
        }
    }

    public IExtension removeExtension(Class<? extends IExtension> clazz) {
        return this.extensionContainer.removeExtension(clazz);
    }

    public boolean removeExtension(IExtension extension) {
        return this.extensionContainer.removeExtension(extension);
    }

    public void removeMapChangeListener(IMapChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setRoot(NodeModel root) {
        this.root = root;
        root.attach();
        root.setMap(this);
    }

    public void setSaved(boolean saved) {
        this.changesPerformedSinceLastSave = saved ? 0 : ++this.changesPerformedSinceLastSave;
    }

    public void setURL(URL v) {
        this.url = v;
    }

    public boolean hasExternalFileChanged() {
        return false;
    }

    public void updateLastKnownFileModificationTime() {
    }

    public void unregistryNodes(NodeModel node) {
        List<NodeModel> children = node.getChildren();
        for (NodeModel child : children) {
            this.unregistryNodes(child);
        }
        String id = node.getID();
        if (id != null) {
            this.nodes.put(id, null);
        }
    }

    public NodeChangeAnnouncer getNodeChangeAnnouncer() {
        return this.nodeChangeAnnouncer;
    }

    public void beforeViewCreated() {
    }

    public boolean isUndoActionRunning() {
        return false;
    }

    NodeModel duplicate(NodeModel source, boolean withChildren) {
        return this.getNodeDuplicator().duplicate(source, this, withChildren);
    }

    public INodeDuplicator getNodeDuplicator() {
        return this.nodeDuplicator;
    }
}

