/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.applet;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.text.html.parser.ParserDelegator;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.ShowSelectionAsRectangleAction;
import org.freeplane.core.util.Compat;
import org.freeplane.features.attribute.ModelessAttributeController;
import org.freeplane.features.explorer.MapExplorerConditionController;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.NextNodeAction;
import org.freeplane.features.filter.NextPresentationItemAction;
import org.freeplane.features.format.FormatController;
import org.freeplane.features.help.HelpController;
import org.freeplane.features.highlight.HighlightController;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.map.MapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.print.PrintController;
import org.freeplane.features.styles.LogicalStyleFilterController;
import org.freeplane.features.styles.MapViewLayout;
import org.freeplane.features.text.TextController;
import org.freeplane.features.time.TimeController;
import org.freeplane.features.ui.FrameController;
import org.freeplane.main.applet.AppletResourceController;
import org.freeplane.main.applet.AppletViewController;
import org.freeplane.main.applet.BModeController;
import org.freeplane.main.applet.BModeControllerFactory;
import org.freeplane.view.swing.features.nodehistory.NodeHistory;
import org.freeplane.view.swing.map.MapViewController;
import org.freeplane.view.swing.map.ViewLayoutTypeAction;

public class FreeplaneApplet
extends JApplet {
    private static final long serialVersionUID = 1L;
    private AppletViewController appletViewController;
    private Controller controller;
    private static boolean instanceInitialized = false;
    static final Lock appletLock = new ReentrantLock();
    private Boolean isLaunchedByJavaWebStart;

    @Override
    public void destroy() {
    }

    @Override
    public void init() {
        this.configureFrame();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    appletLock.lock();
                    AppletResourceController appletResourceController = new AppletResourceController(FreeplaneApplet.this);
                    new ParserDelegator(){
                        {
                            1.setDefaultDTD();
                        }
                    };
                    Compat.setIsApplet(true);
                    FreeplaneApplet.this.controller = new Controller(appletResourceController);
                    FreeplaneApplet.this.updateLookAndFeel(appletResourceController);
                    Controller.setCurrentController(FreeplaneApplet.this.controller);
                    Container contentPane = FreeplaneApplet.this.getContentPane();
                    contentPane.setLayout(new BorderLayout());
                    MapViewController mapViewController = new MapViewController(FreeplaneApplet.this.controller);
                    FreeplaneApplet.this.appletViewController = new AppletViewController(FreeplaneApplet.this, FreeplaneApplet.this.controller, mapViewController);
                    FreeplaneApplet.this.controller.addAction(new ViewLayoutTypeAction(MapViewLayout.OUTLINE));
                    FreeplaneApplet.this.controller.addExtension(HighlightController.class, new HighlightController());
                    FilterController.install();
                    PrintController.install();
                    HelpController.install();
                    NodeHistory.install(FreeplaneApplet.this.controller);
                    FormatController.install(new FormatController());
                    ModelessAttributeController.install();
                    TextController.install();
                    MapController.install();
                    MapExplorerConditionController.installFilterConditions();
                    TimeController.install();
                    LinkController.install();
                    IconController.installConditionControllers();
                    FilterController.getCurrentFilterController().getConditionFactory().addConditionController(70, new LogicalStyleFilterController());
                    BModeController browseController = BModeControllerFactory.createModeController();
                    Set<String> emptySet = Collections.emptySet();
                    FilterController.getController(FreeplaneApplet.this.controller).loadDefaultConditions();
                    FreeplaneApplet.this.controller.addAction(new ShowSelectionAsRectangleAction());
                    FreeplaneApplet.this.controller.addAction(new NextNodeAction(MapController.Direction.FORWARD));
                    FreeplaneApplet.this.controller.addAction(new NextNodeAction(MapController.Direction.BACK));
                    FreeplaneApplet.this.controller.addAction(new NextNodeAction(MapController.Direction.FORWARD_N_FOLD));
                    FreeplaneApplet.this.controller.addAction(new NextNodeAction(MapController.Direction.BACK_N_FOLD));
                    FreeplaneApplet.this.controller.addAction(NextPresentationItemAction.createFoldingAction());
                    FreeplaneApplet.this.controller.addAction(NextPresentationItemAction.createNotFoldingAction());
                    browseController.updateMenus("/xml/appletmenu.xml", emptySet);
                    appletResourceController.getAcceleratorManager().loadAcceleratorPresets();
                    FreeplaneApplet.this.controller.selectMode(browseController);
                    FreeplaneApplet.this.setPropertyByParameter(appletResourceController, "browsemode_initial_map");
                    FreeplaneApplet.this.isLaunchedByJavaWebStart = FreeplaneApplet.this.isParameterTrue("launched_by_java_web_start");
                    if (FreeplaneApplet.this.isLaunchedByJavaWebStart.booleanValue()) {
                        if (instanceInitialized) {
                            throw new RuntimeException("singleAppletInstance allowed");
                        }
                        instanceInitialized = true;
                    } else {
                        FreeplaneApplet.this.addGlassPane();
                    }
                    FreeplaneApplet.this.controller.getViewController().setMenubarVisible(false);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            FreeplaneApplet.this.appletViewController.init(FreeplaneApplet.this.controller);
                        }
                    });
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    throw e;
                }
                finally {
                    appletLock.unlock();
                }
            }
        }, "Freeplane applet initialization").start();
    }

    private Boolean isParameterTrue(String name) {
        return Boolean.valueOf(this.getParameter(name));
    }

    private void configureFrame() {
        Window window = SwingUtilities.windowForComponent(this);
        if (window instanceof Frame) {
            Frame frame = (Frame)window;
            ImageIcon mWindowIcon = new ImageIcon(this.getClass().getResource("/images/Freeplane_frame_icon_64x64.png"));
            frame.setIconImage(mWindowIcon.getImage());
            if (!frame.isResizable()) {
                frame.setResizable(true);
            }
        }
    }

    private void addGlassPane() {
        GlassPane glassPane = new GlassPane(this.controller);
        this.setGlassPane(glassPane);
        glassPane.setVisible(true);
    }

    private void updateLookAndFeel(ResourceController appletResourceController) {
        String lookAndFeel = "";
        this.setPropertyByParameter(appletResourceController, "lookandfeel");
        lookAndFeel = appletResourceController.getProperty("lookandfeel");
        FrameController.setLookAndFeel(lookAndFeel);
    }

    @Override
    public Component findComponentAt(int x, int y) {
        Component c = super.findComponentAt(x, y);
        if (c == null) {
            return null;
        }
        AWTEvent currentEvent = EventQueue.getCurrentEvent();
        if (this.controller != Controller.getCurrentController() && currentEvent instanceof MouseEvent && currentEvent.getID() == 503 && appletLock.tryLock()) {
            Controller.setCurrentController(this.controller);
            appletLock.unlock();
        }
        return c;
    }

    public void setWaitingCursor(boolean waiting) {
        Component glassPane = this.getRootPane().getGlassPane();
        if (waiting) {
            glassPane.setCursor(Cursor.getPredefinedCursor(3));
            glassPane.setVisible(true);
        } else {
            glassPane.setCursor(Cursor.getPredefinedCursor(0));
            glassPane.setVisible(false);
        }
    }

    void setPropertyByParameter(ResourceController resourceController, String key) {
        String val = this.getParameter(key);
        if (val != null && val != "") {
            resourceController.setProperty(key, val);
        }
    }

    public void showDocument(URL doc) {
        if (this.isLaunchedByJavaWebStart.booleanValue() && Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(doc.toURI());
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.getAppletContext().showDocument(doc, "_blank");
    }

    private static class GlassPane
    extends JComponent {
        private final Controller controller;

        public GlassPane(Controller controller) {
            this.controller = controller;
            this.addMouseListener(new MouseAdapter(){});
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            if (e.getID() == 505) {
                return;
            }
            Controller currentController = Controller.getCurrentController();
            if (this.controller != currentController) {
                if (!appletLock.tryLock()) {
                    return;
                }
                Controller.setCurrentController(this.controller);
                appletLock.unlock();
                JOptionPane.getFrameForComponent(this).getMostRecentFocusOwner().requestFocus();
                if (currentController != null) {
                    ((FreeplaneApplet)currentController.getViewController().getMenuComponent()).getGlassPane().setVisible(true);
                }
            }
            this.setVisible(false);
        }
    }
}

