/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.overview.resizable;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.EnumSet;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import org.freeplane.core.util.Compat;
import org.freeplane.view.swing.map.overview.MapOverviewAttachPoint;
import org.freeplane.view.swing.map.overview.MapViewPane;
import org.freeplane.view.swing.map.overview.resizable.ResizablePanelBorder;

public class ResizePanelMouseHandler
extends MouseInputAdapter {
    static final int COMPAT_MOVE_CURSOR = Compat.isMacOsX() ? 12 : 13;
    private final Point startLocation = new Point();
    private final Rectangle startBounds = new Rectangle();
    private Cursor cursor;

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() != 2 || e.getButton() != 1) {
            return;
        }
        int cursorType = Optional.ofNullable(this.cursor).map(Cursor::getType).orElse(0);
        MouseDragAction.getByCursorType(cursorType).ifPresent(action -> {
            int ordinal = action.ordinal();
            if (ordinal > MouseDragAction.RESIZE_EAST.ordinal() && ordinal < MouseDragAction.MOVE_COMPONENT.ordinal()) {
                MapOverviewAttachPoint attachPoint = MapOverviewAttachPoint.values()[ordinal - MouseDragAction.RESIZE_NORTH_WEST.ordinal()];
                MapViewPane mapViewPane = (MapViewPane)e.getComponent().getParent();
                mapViewPane.updateMapOverviewAttachPoint(attachPoint);
            }
        });
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        JComponent c = (JComponent)e.getComponent();
        ResizablePanelBorder border = (ResizablePanelBorder)c.getBorder();
        c.setCursor(border.getResizeCursor(e));
    }

    @Override
    public void mouseExited(MouseEvent e) {
        e.getComponent().setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void mousePressed(MouseEvent e) {
        JComponent c = (JComponent)e.getComponent();
        ResizablePanelBorder border = (ResizablePanelBorder)c.getBorder();
        this.cursor = border.getResizeCursor(e);
        this.startLocation.setLocation(SwingUtilities.convertPoint(c, e.getX(), e.getY(), null));
        this.startBounds.setBounds(c.getBounds());
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.startBounds.setSize(0, 0);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.startBounds.isEmpty()) {
            return;
        }
        Component resizedPanel = e.getComponent();
        Point targetPoint = SwingUtilities.convertPoint(resizedPanel, e.getX(), e.getY(), null);
        int deltaX = this.startLocation.x - targetPoint.x;
        int deltaY = this.startLocation.y - targetPoint.y;
        if (!resizedPanel.getCursor().equals(this.cursor)) {
            resizedPanel.setCursor(this.cursor);
        }
        MapViewPane mapViewPane = (MapViewPane)e.getComponent().getParent();
        int cursorType = Optional.ofNullable(this.cursor).map(Cursor::getType).orElse(0);
        MouseDragAction.getByCursorType(cursorType).ifPresent(action -> {
            Dimension delta = this.getLimitedDimensionDelta(cursorType, mapViewPane.getBounds(), deltaX, deltaY);
            mapViewPane.setMapOverviewBounds(action.getTargetBounds(this.startBounds, delta));
        });
    }

    private int getDeltaX(int dx) {
        int left = Math.min(MapViewPane.MAP_OVERVIEW_MAX_SIZE - this.startBounds.width, this.startBounds.x);
        return Math.max(Math.min(dx, left), MapViewPane.MAP_OVERVIEW_MIN_SIZE - this.startBounds.width);
    }

    private int getDeltaX(int dx, Rectangle pr) {
        int right = Math.max(this.startBounds.width - MapViewPane.MAP_OVERVIEW_MAX_SIZE, this.startBounds.x + this.startBounds.width - pr.width);
        return Math.min(Math.max(dx, right), this.startBounds.width - MapViewPane.MAP_OVERVIEW_MIN_SIZE);
    }

    private int getDeltaY(int dy) {
        int top = Math.min(MapViewPane.MAP_OVERVIEW_MAX_SIZE - this.startBounds.height, this.startBounds.y);
        return Math.max(Math.min(dy, top), MapViewPane.MAP_OVERVIEW_MIN_SIZE - this.startBounds.height);
    }

    private int getDeltaY(int dy, Rectangle pr) {
        int bottom = Math.max(this.startBounds.height - MapViewPane.MAP_OVERVIEW_MAX_SIZE, this.startBounds.y + this.startBounds.height - pr.height);
        return Math.min(Math.max(dy, bottom), this.startBounds.height - MapViewPane.MAP_OVERVIEW_MIN_SIZE);
    }

    private Dimension getLimitedDimensionDelta(int cursorType, Rectangle pr, int deltaX, int deltaY) {
        switch (cursorType) {
            case 8: {
                return new Dimension(0, this.getDeltaY(deltaY));
            }
            case 9: {
                return new Dimension(0, this.getDeltaY(deltaY, pr));
            }
            case 10: {
                return new Dimension(this.getDeltaX(deltaX), 0);
            }
            case 11: {
                return new Dimension(this.getDeltaX(deltaX, pr), 0);
            }
            case 6: {
                return new Dimension(this.getDeltaX(deltaX), this.getDeltaY(deltaY));
            }
            case 4: {
                return new Dimension(this.getDeltaX(deltaX), this.getDeltaY(deltaY, pr));
            }
            case 7: {
                return new Dimension(this.getDeltaX(deltaX, pr), this.getDeltaY(deltaY));
            }
            case 5: {
                return new Dimension(this.getDeltaX(deltaX, pr), this.getDeltaY(deltaY, pr));
            }
        }
        return new Dimension(deltaX, deltaY);
    }

    private static enum MouseDragAction {
        RESIZE_NORTH(8){

            @Override
            Rectangle getTargetBounds(Rectangle startBounds, Dimension d) {
                return new Rectangle(startBounds.x, startBounds.y - d.height, startBounds.width, startBounds.height + d.height);
            }
        }
        ,
        RESIZE_SOUTH(9){

            @Override
            Rectangle getTargetBounds(Rectangle startBounds, Dimension d) {
                return new Rectangle(startBounds.x, startBounds.y, startBounds.width, startBounds.height - d.height);
            }
        }
        ,
        RESIZE_WEST(10){

            @Override
            Rectangle getTargetBounds(Rectangle startBounds, Dimension d) {
                return new Rectangle(startBounds.x - d.width, startBounds.y, startBounds.width + d.width, startBounds.height);
            }
        }
        ,
        RESIZE_EAST(11){

            @Override
            Rectangle getTargetBounds(Rectangle startBounds, Dimension d) {
                return new Rectangle(startBounds.x, startBounds.y, startBounds.width - d.width, startBounds.height);
            }
        }
        ,
        RESIZE_NORTH_WEST(6){

            @Override
            Rectangle getTargetBounds(Rectangle startBounds, Dimension d) {
                return new Rectangle(startBounds.x - d.width, startBounds.y - d.height, startBounds.width + d.width, startBounds.height + d.height);
            }
        }
        ,
        RESIZE_NORTH_EAST(7){

            @Override
            Rectangle getTargetBounds(Rectangle startBounds, Dimension d) {
                return new Rectangle(startBounds.x, startBounds.y - d.height, startBounds.width - d.width, startBounds.height + d.height);
            }
        }
        ,
        RESIZE_SOUTH_WEST(4){

            @Override
            Rectangle getTargetBounds(Rectangle startBounds, Dimension d) {
                return new Rectangle(startBounds.x - d.width, startBounds.y, startBounds.width + d.width, startBounds.height - d.height);
            }
        }
        ,
        RESIZE_SOUTH_EAST(5){

            @Override
            Rectangle getTargetBounds(Rectangle startBounds, Dimension d) {
                return new Rectangle(startBounds.x, startBounds.y, startBounds.width - d.width, startBounds.height - d.height);
            }
        }
        ,
        MOVE_COMPONENT(COMPAT_MOVE_CURSOR){

            @Override
            Rectangle getTargetBounds(Rectangle startBounds, Dimension d) {
                return new Rectangle(startBounds.x - d.width, startBounds.y - d.height, startBounds.width, startBounds.height);
            }
        };

        private final int cursor;

        private MouseDragAction(int cursor) {
            this.cursor = cursor;
        }

        abstract Rectangle getTargetBounds(Rectangle var1, Dimension var2);

        public static Optional<MouseDragAction> getByCursorType(int cursor) {
            return EnumSet.allOf(MouseDragAction.class).stream().filter(d -> d.cursor == cursor).findFirst();
        }
    }
}

