/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.lang.extension;

import com.tngtech.archunit.ArchConfiguration;
import com.tngtech.archunit.Internal;
import com.tngtech.archunit.lang.extension.ArchUnitExtension;
import com.tngtech.archunit.lang.extension.ArchUnitExtensionLoader;
import com.tngtech.archunit.lang.extension.EvaluatedRule;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class ArchUnitExtensions {
    private static final Logger LOG = LoggerFactory.getLogger(ArchUnitExtensions.class);
    private static final String ENABLED_PROPERTY = "enabled";
    private final ArchUnitExtensionLoader extensionLoader;

    public ArchUnitExtensions() {
        this(new ArchUnitExtensionLoader());
    }

    private ArchUnitExtensions(ArchUnitExtensionLoader extensionLoader) {
        this.extensionLoader = extensionLoader;
    }

    public void dispatch(EvaluatedRule evaluatedRule) {
        for (ArchUnitExtension extension : this.extensionLoader.getAll()) {
            this.dispatch(evaluatedRule, extension);
        }
    }

    private void dispatch(EvaluatedRule evaluatedRule, ArchUnitExtension extension) {
        ArchConfiguration configuration = ArchConfiguration.get();
        Properties extensionProperties = configuration.getExtensionProperties(extension.getUniqueIdentifier());
        if (this.isEnabled(extensionProperties).booleanValue()) {
            this.configureAndDispatch(extension, extensionProperties, evaluatedRule);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Extension '{}' is disabled, skipping... (to enable this extension, configure extension.{}.{}=true)", new Object[]{extension.getUniqueIdentifier(), extension.getUniqueIdentifier(), ENABLED_PROPERTY});
        }
    }

    private Boolean isEnabled(Properties extensionProperties) {
        return Boolean.valueOf(extensionProperties.getProperty(ENABLED_PROPERTY, "false"));
    }

    private void configureAndDispatch(ArchUnitExtension extension, Properties extensionProperties, EvaluatedRule evaluatedRule) {
        try {
            extension.configure(extensionProperties);
            extension.handle(evaluatedRule);
        }
        catch (RuntimeException e) {
            LOG.warn(String.format("Error in extension '%s'", extension.getUniqueIdentifier()), (Throwable)e);
        }
    }
}

