/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.border;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import net.infonode.gui.InsetsUtil;

public class BorderUtil {
    private BorderUtil() {
    }

    public static Insets getInsetsOutside(Component c, Border border, Border outside) {
        Insets insets = new Insets(0, 0, 0, 0);
        BorderUtil.getInsetsOutside(c, border, outside, insets);
        return insets;
    }

    private static boolean getInsetsOutside(Component c, Border border, Border outside, Insets insets) {
        if (border == null) {
            return false;
        }
        if (border == outside) {
            return true;
        }
        if (border instanceof CompoundBorder) {
            CompoundBorder b = (CompoundBorder)border;
            return BorderUtil.getInsetsOutside(c, b.getOutsideBorder(), outside, insets) || BorderUtil.getInsetsOutside(c, b.getInsideBorder(), outside, insets);
        }
        InsetsUtil.addTo(insets, border.getBorderInsets(c));
        return false;
    }

    public static Border copy(final Border border) {
        return new Border(){

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                border.paintBorder(c, g, x, y, width, height);
            }

            @Override
            public Insets getBorderInsets(Component c) {
                return border.getBorderInsets(c);
            }

            @Override
            public boolean isBorderOpaque() {
                return border.isBorderOpaque();
            }
        };
    }
}

