/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.properties.propertymap.value;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.infonode.properties.base.Property;
import net.infonode.properties.base.exception.InvalidPropertyTypeException;
import net.infonode.properties.propertymap.PropertyMapImpl;
import net.infonode.properties.propertymap.ref.PropertyMapRef;
import net.infonode.properties.propertymap.ref.PropertyMapRefDecoder;
import net.infonode.properties.propertymap.value.PropertyValue;
import net.infonode.util.Printer;
import net.infonode.util.ValueChange;
import net.infonode.util.collection.map.base.ConstMap;
import net.infonode.util.signal.Signal;
import net.infonode.util.signal.SignalListener;

public class PropertyRefValue
implements PropertyValue,
SignalListener {
    private PropertyMapImpl map;
    private Property property;
    private PropertyMapRef propertyObjectRef;
    private Property propertyRef;
    private PropertyRefValue parentRef;

    public PropertyRefValue(PropertyMapImpl map, Property property, PropertyMapRef propertyObjectRef, Property propertyRef, PropertyRefValue parentRef) {
        if (!property.getType().isAssignableFrom(propertyRef.getType())) {
            throw new InvalidPropertyTypeException(property, propertyRef, "Can't create reference from Property '" + property + "' to property '" + propertyRef + "' because they are of incompatible types!");
        }
        this.map = map;
        this.property = property;
        this.propertyObjectRef = propertyObjectRef;
        this.propertyRef = propertyRef;
        this.parentRef = parentRef;
    }

    public Property getProperty() {
        return this.property;
    }

    public PropertyMapImpl getMap() {
        return this.map;
    }

    @Override
    public void updateListener(boolean enable) {
        if (enable) {
            this.propertyObjectRef.getMap(this.map).getMap().getChangeSignal().add(this);
        } else {
            this.propertyObjectRef.getMap(this.map).getMap().getChangeSignal().remove(this);
        }
    }

    @Override
    public PropertyValue getParent() {
        return this.parentRef;
    }

    @Override
    public Object get(PropertyMapImpl object) {
        PropertyMapImpl o = this.propertyObjectRef.getMap(object);
        PropertyValue v = (o == null ? this.propertyObjectRef.getMap(this.map) : o).getValue(this.propertyRef);
        return v == null ? null : v.get(o);
    }

    @Override
    public Object getWithDefault(PropertyMapImpl object) {
        PropertyMapImpl o = this.propertyObjectRef.getMap(object);
        PropertyValue v = (o == null ? this.propertyObjectRef.getMap(this.map) : o).getValueWithDefault(this.propertyRef);
        return v == null ? null : v.getWithDefault(o);
    }

    @Override
    public PropertyValue getSubValue(PropertyMapImpl object) {
        PropertyMapImpl newObject = this.propertyObjectRef.getMap(object);
        if (newObject == null) {
            return null;
        }
        if (!newObject.getPropertyGroup().hasProperty(this.propertyRef)) {
            return null;
        }
        return new PropertyRefValue(object, this.property, this.propertyObjectRef, this.propertyRef, this);
    }

    @Override
    public void unset() {
        this.propertyObjectRef.getMap(this.map).getMap().getChangeSignal().remove(this);
    }

    @Override
    public void signalEmitted(Signal signal, Object object) {
        ConstMap changes = (ConstMap)object;
        ValueChange vc = (ValueChange)changes.get(this.propertyRef);
        if (vc != null) {
            this.map.firePropertyValueChanged(this.property, new ValueChange(vc.getOldValue(), this));
        }
    }

    public String toString() {
        return "ref -> " + this.propertyObjectRef + '.' + this.propertyRef;
    }

    @Override
    public void dump(Printer printer) {
        printer.println(this.toString());
    }

    @Override
    public void write(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        this.propertyObjectRef.write(out);
        out.writeUTF(this.propertyRef.getName());
    }

    @Override
    public boolean isSerializable() {
        return true;
    }

    public static PropertyValue decode(ObjectInputStream in, PropertyMapImpl propertyObject, Property property) throws IOException {
        PropertyMapRef ref = PropertyMapRefDecoder.decode(in);
        String propertyName = in.readUTF();
        if (property == null || ref == null) {
            return null;
        }
        Property refProperty = ref.getMap(propertyObject).getPropertyGroup().getProperty(propertyName);
        if (refProperty == null) {
            return null;
        }
        return new PropertyRefValue(propertyObject, property, ref, refProperty, null);
    }

    public static void skip(ObjectInputStream in) throws IOException {
        PropertyMapRefDecoder.decode(in);
        in.readUTF();
    }

    @Override
    public PropertyValue copyTo(PropertyMapImpl propertyMap) {
        return new PropertyRefValue(propertyMap, this.property, this.propertyObjectRef, this.propertyRef, null);
    }
}

