/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.task;

import com.tngtech.archunit.core.importer.ImportOption;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.freeplane.features.mode.Controller;
import org.freeplane.plugin.codeexplorer.dependencies.DependencyDirection;
import org.freeplane.plugin.codeexplorer.dependencies.DependencyRule;
import org.freeplane.plugin.codeexplorer.dependencies.DependencyVerdict;
import org.freeplane.plugin.codeexplorer.task.AnnotationMatcher;
import org.freeplane.plugin.codeexplorer.task.ClassNameMatcher;
import org.freeplane.plugin.codeexplorer.task.ConfigurationChange;
import org.freeplane.plugin.codeexplorer.task.DependencyRuleJudge;
import org.freeplane.plugin.codeexplorer.task.DirectoryMatcher;
import org.freeplane.plugin.codeexplorer.task.IgnoredClassMatcher;

public class ParsedConfiguration {
    public static final String HELP;
    private static final String CLASS_PATTERN = "[\\w\\.\\|\\(\\)\\*\\[\\]]+";
    private static final String DIRECTION_PATTERN;
    private static final Pattern DEPENDENCY_RULE_PATTERN;
    private static final Pattern CLASSPATH_PATTERN;
    private static final Pattern IGNORED_CLASS_PATTERN;
    private static final Pattern IMPORTED_ANNOTATION_PATTERN;
    private static final Pattern GROUP_PATTERN;
    private final List<DependencyRule> rules;
    private final IgnoredClassMatcher ignoredClasses;
    private final AnnotationMatcher annotationMatcher;
    private final List<String> subpaths;
    private final List<ClassNameMatcher> groupMatchers;

    public ParsedConfiguration(String dsl) {
        String[] dslRules;
        ArrayList<DependencyRule> dependencyRules = new ArrayList<DependencyRule>();
        ArrayList<String> ignoredClasses = new ArrayList<String>();
        ArrayList<String> importedAnnotations = new ArrayList<String>();
        ArrayList<String> subpaths = new ArrayList<String>();
        ArrayList<ClassNameMatcher> groupMatchers = new ArrayList<ClassNameMatcher>();
        for (String dslRuleLine : dslRules = dsl.split("\\n\\s*")) {
            String dslRule = dslRuleLine.trim();
            if (dslRule.isEmpty() || dslRule.startsWith("#") || dslRule.startsWith("//")) continue;
            Matcher dependencyMatcher = DEPENDENCY_RULE_PATTERN.matcher(dslRule);
            if (dependencyMatcher.find()) {
                DependencyVerdict type = DependencyVerdict.parseVerdict(dependencyMatcher.group(1));
                String originPattern = dependencyMatcher.group(2);
                String directionNotation = dependencyMatcher.group(3);
                String targetPattern = dependencyMatcher.group(4);
                DependencyDirection dependencyDirection = DependencyDirection.parseDirection(directionNotation);
                DependencyRule rule = new DependencyRule(type, originPattern, targetPattern, dependencyDirection);
                dependencyRules.add(rule);
                continue;
            }
            Matcher classpathMatcher = CLASSPATH_PATTERN.matcher(dslRule);
            if (classpathMatcher.find()) {
                subpaths.add(classpathMatcher.group(1));
                continue;
            }
            Matcher ignoredClassMatcher = IGNORED_CLASS_PATTERN.matcher(dslRule);
            if (ignoredClassMatcher.find()) {
                ignoredClasses.add(ignoredClassMatcher.group(1));
                continue;
            }
            Matcher groupPatternMatcher = GROUP_PATTERN.matcher(dslRule);
            if (groupPatternMatcher.find()) {
                boolean ignores = groupPatternMatcher.group(1) != null;
                boolean matchesClasses = groupPatternMatcher.group(2) != null;
                String pattern = groupPatternMatcher.group(3);
                Optional<String> name = Optional.ofNullable(groupPatternMatcher.group(4));
                groupMatchers.add(new ClassNameMatcher(pattern, ignores, matchesClasses, name));
                continue;
            }
            Matcher importedAnnotationMatcher = IMPORTED_ANNOTATION_PATTERN.matcher(dslRule);
            if (importedAnnotationMatcher.find()) {
                String annotationPattern = importedAnnotationMatcher.group(2);
                if (annotationPattern.endsWith("()") && importedAnnotationMatcher.group(1).equals("interface")) {
                    throw new IllegalArgumentException("Invalid rule " + dslRule);
                }
                importedAnnotations.add(annotationPattern);
                continue;
            }
            throw new IllegalArgumentException("Invalid rule " + dslRule);
        }
        this.rules = dependencyRules;
        this.ignoredClasses = new IgnoredClassMatcher(ignoredClasses);
        this.annotationMatcher = new AnnotationMatcher(importedAnnotations);
        this.subpaths = subpaths;
        this.groupMatchers = groupMatchers;
    }

    public DependencyRuleJudge judge() {
        return new DependencyRuleJudge(this.rules);
    }

    public AnnotationMatcher annotationMatcher() {
        return this.annotationMatcher;
    }

    public DirectoryMatcher directoryMatcher(Collection<File> locations) {
        return new DirectoryMatcher(locations, this.subpaths, this.groupMatchers);
    }

    public ImportOption importOption() {
        return this.ignoredClasses;
    }

    public ConfigurationChange configurationChange(ParsedConfiguration previousConfiguration) {
        if (previousConfiguration == null || !this.subpaths.equals(previousConfiguration.subpaths) || !this.ignoredClasses.equals(previousConfiguration.ignoredClasses)) {
            return ConfigurationChange.CODE_BASE;
        }
        if (!this.rules.equals(previousConfiguration.rules) || !this.annotationMatcher.equals(previousConfiguration.annotationMatcher)) {
            return ConfigurationChange.CONFIGURATION;
        }
        if (!this.groupMatchers.equals(previousConfiguration.groupMatchers)) {
            return ConfigurationChange.GROUPS;
        }
        return ConfigurationChange.SAME;
    }

    static {
        Controller currentController = Controller.getCurrentController();
        HELP = currentController != null ? currentController.getResourceController().loadString("/org/freeplane/plugin/codeexplorer/documentation.txt") : "";
        DIRECTION_PATTERN = Pattern.quote(DependencyDirection.UP.notation) + "|" + Pattern.quote(DependencyDirection.DOWN.notation) + "|" + Pattern.quote(DependencyDirection.ANY.notation);
        DEPENDENCY_RULE_PATTERN = Pattern.compile("^\\s*(" + DependencyVerdict.ALLOWED.keyword + "|" + DependencyVerdict.FORBIDDEN.keyword + "|" + DependencyVerdict.IGNORED.keyword + ")\\s+(" + CLASS_PATTERN + ")\\s*(" + DIRECTION_PATTERN + ")\\s*(" + CLASS_PATTERN + ")\\s*$");
        CLASSPATH_PATTERN = Pattern.compile("^\\s*classpath\\s+/*(.*\\S)\\s*$");
        IGNORED_CLASS_PATTERN = Pattern.compile("^\\s*ignore\\s+class\\s+([\\w\\.\\|\\(\\)\\*\\[\\]]+)\\s*$");
        IMPORTED_ANNOTATION_PATTERN = Pattern.compile("^\\s*import\\s+(annotation|interface)\\s+([\\w\\.\\|\\(\\)\\*\\[\\]]+)\\s*$");
        GROUP_PATTERN = Pattern.compile("^\\s*(?:(ignore)\\s+)?(?:(class)\\s+)?group\\s+([\\w\\.\\|\\(\\)\\*\\[\\]]+)(?:\\s+as\\s+(.*?))?\\s*$");
    }
}

