/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon.mindmapmode;

import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.FreeplaneToolBar;
import org.freeplane.features.icon.mindmapmode.IconAction;
import org.freeplane.features.mode.ModeController;

public class FastAccessableIcons {
    private static final String FAST_ACCESS_ICON_NUMBER_PROPERTY = "fast_access_icon_number";
    private final DefaultListModel<AFreeplaneAction> actions;
    private final ModeController modeController;

    public FastAccessableIcons(ModeController modeController) {
        this.modeController = modeController;
        this.actions = new DefaultListModel();
    }

    public void add(IconAction action) {
        int actionCount = this.actions.size();
        if (this.actions.indexOf((Object)action) >= 0) {
            return;
        }
        int maxActionCount = Math.max(0, ResourceController.getResourceController().getIntProperty(FAST_ACCESS_ICON_NUMBER_PROPERTY));
        if (maxActionCount < actionCount) {
            this.actions.removeRange(maxActionCount > 1 ? maxActionCount - 1 : 0, actionCount - 1);
        }
        if (maxActionCount >= 1) {
            this.actions.add(0, (AFreeplaneAction)action);
        }
    }

    public String getInitializer() {
        StringBuilder builder = new StringBuilder();
        int actionCount = this.actions.size();
        for (int index = actionCount - 1; index >= 0; --index) {
            AFreeplaneAction buttonAction = this.actions.elementAt(index);
            builder.append(buttonAction.getKey());
            if (index <= 0) continue;
            builder.append(';');
        }
        return builder.toString();
    }

    public void load(String initializer) {
        Stream.of(initializer.split(";")).map(arg_0 -> ((ModeController)this.modeController).getAction(arg_0)).filter(IconAction.class::isInstance).map(IconAction.class::cast).forEach(this::add);
    }

    public ActionPanel createActionPanel(AFreeplaneAction ... controlActions) {
        ActionPanel panel = new ActionPanel(controlActions);
        return panel;
    }

    public class ActionPanel
    extends FreeplaneToolBar {
        private final AFreeplaneAction[] controlActions;
        private static final long serialVersionUID = 1L;
        private ListDataListener l;
        private Consumer<AbstractButton> buttonConfigurer;

        public void setButtonConfigurer(Consumer<AbstractButton> buttonConfigurer) {
            this.buttonConfigurer = buttonConfigurer;
        }

        private ActionPanel(final AFreeplaneAction[] controlActions) {
            super(1);
            this.controlActions = controlActions;
            this.l = new ListDataListener(){

                @Override
                public void intervalRemoved(ListDataEvent e) {
                    int index0;
                    for (int i = index0 = e.getIndex0(); i <= e.getIndex1(); ++i) {
                        ActionPanel.this.remove(controlActions.length + index0);
                    }
                    ActionPanel.this.revalidate();
                    ActionPanel.this.repaint();
                }

                @Override
                public void intervalAdded(ListDataEvent e) {
                    for (int i = e.getIndex0(); i <= e.getIndex1(); ++i) {
                        AbstractButton button = ActionPanel.this.createAndConfigureButton((AFreeplaneAction)FastAccessableIcons.this.actions.elementAt(i));
                        ActionPanel.this.add(button, controlActions.length + i);
                    }
                    ActionPanel.this.revalidate();
                    ActionPanel.this.repaint();
                }

                @Override
                public void contentsChanged(ListDataEvent e) {
                    this.intervalRemoved(e);
                    this.intervalAdded(e);
                }
            };
        }

        public void addNotify() {
            AbstractButton button;
            int i;
            for (i = 0; i < this.controlActions.length; ++i) {
                button = this.createAndConfigureButton(this.controlActions[i]);
                this.add(button);
            }
            for (i = 0; i < FastAccessableIcons.this.actions.size(); ++i) {
                button = this.createAndConfigureButton((AFreeplaneAction)FastAccessableIcons.this.actions.elementAt(i));
                this.add(button);
            }
            FastAccessableIcons.this.actions.addListDataListener(this.l);
            super.addNotify();
        }

        private AbstractButton createAndConfigureButton(AFreeplaneAction action) {
            AbstractButton button = FreeplaneToolBar.createButton((AFreeplaneAction)action);
            if (this.buttonConfigurer != null) {
                this.buttonConfigurer.accept(button);
            }
            return button;
        }

        public void removeNotify() {
            super.removeNotify();
            FastAccessableIcons.this.actions.removeListDataListener(this.l);
            this.removeAll();
        }
    }
}

