/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon.mindmapmode;

import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.IconSelectionPopupDialog;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.features.icon.EmojiIcon;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.IconDescription;
import org.freeplane.features.icon.mindmapmode.FastAccessableIcons;
import org.freeplane.features.icon.mindmapmode.MIconController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;

public class IconSelectionPlugin
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;
    private static final String ADD_EMOJIS_TO_ICON_SELECTOR = "add_emojis_to_icon_selector";
    private IconSelectionPopupDialog selectionDialog;

    public IconSelectionPlugin() {
        super("IconSelectionPlugin");
    }

    private boolean areEmojisAvailbleFromIconSelector() {
        return ResourceController.getResourceController().getBooleanProperty(ADD_EMOJIS_TO_ICON_SELECTOR);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.selectionDialog == null) {
            this.showDialog();
        } else {
            this.selectionDialog.toFront();
        }
    }

    private void showDialog() {
        ModeController modeController = Controller.getCurrentModeController();
        ArrayList<IconDescription> actions = new ArrayList<IconDescription>();
        Controller controller = Controller.getCurrentController();
        actions.add((IconDescription)modeController.getAction("RemoveIcon_0_Action"));
        actions.add((IconDescription)modeController.getAction("RemoveIconAction"));
        actions.add((IconDescription)modeController.getAction("RemoveAllIconsAction"));
        MIconController mIconController = (MIconController)IconController.getController();
        Collection<AFreeplaneAction> iconActions = this.areEmojisAvailbleFromIconSelector() ? mIconController.getIconActions() : mIconController.getIconActions(icon -> !(icon instanceof EmojiIcon));
        for (AFreeplaneAction aFreeplaneAction : iconActions) {
            actions.add((IconDescription)aFreeplaneAction);
        }
        this.selectionDialog = new IconSelectionPopupDialog(UITools.getCurrentFrame(), actions);
        FastAccessableIcons.ActionPanel controls = mIconController.createActionPanelWithControlActions();
        this.selectionDialog.addActionPanel(controls);
        NodeModel selected = controller.getSelection().getSelected();
        controller.getMapViewManager().scrollNodeToVisible(selected);
        this.selectionDialog.setModal(false);
        this.selectionDialog.setActionListener(evt -> {
            Action action;
            int result = this.selectionDialog.getIconIndex();
            if (result >= 0 && (action = (Action)actions.get(result)).isEnabled()) {
                action.actionPerformed(new ActionEvent(action, 0, "icon", this.selectionDialog.getModifiers()));
            }
        });
        this.selectionDialog.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                IconSelectionPlugin.this.selectionDialog = null;
            }
        });
        this.selectionDialog.show();
    }
}

