/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.layout.mindmapmode;

import org.freeplane.api.ChildNodesLayout;
import org.freeplane.core.undo.IActor;
import org.freeplane.features.layout.LayoutModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;

class ChangeChildNodesLayoutActor
implements IActor {
    private final NodeModel node;
    private final ChildNodesLayout oldSides;
    private final ChildNodesLayout newSides;

    ChangeChildNodesLayoutActor(NodeModel node, ChildNodesLayout newSides) {
        LayoutModel layoutModel = LayoutModel.getModel((NodeModel)node);
        this.oldSides = layoutModel.getChildNodesLayout();
        this.node = node;
        this.newSides = newSides;
    }

    public void act() {
        this.setSides(this.node, this.oldSides, this.newSides);
    }

    public String getDescription() {
        return "changeChildNodesLayout";
    }

    private void setSides(NodeModel node, ChildNodesLayout oldLayout, ChildNodesLayout newLayout) {
        if (oldLayout != newLayout) {
            LayoutModel.createLayoutModel((NodeModel)node).setChildNodesLayout(newLayout);
            Controller.getCurrentModeController().getMapController().nodeChanged(node, ChildNodesLayout.class, (Object)oldLayout, (Object)newLayout);
        }
    }

    public void undo() {
        this.setSides(this.node, this.newSides, this.oldSides);
    }
}

